/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.tls;

import cn.org.bjca.gaia.crypto.tls.AbstractTlsServer;
import cn.org.bjca.gaia.crypto.tls.DefaultTlsCipherFactory;
import cn.org.bjca.gaia.crypto.tls.TlsCipherFactory;
import cn.org.bjca.gaia.crypto.tls.TlsCredentials;
import cn.org.bjca.gaia.crypto.tls.TlsFatalAlert;
import cn.org.bjca.gaia.crypto.tls.TlsKeyExchange;
import cn.org.bjca.gaia.crypto.tls.TlsSRPIdentityManager;
import cn.org.bjca.gaia.crypto.tls.TlsSRPKeyExchange;
import cn.org.bjca.gaia.crypto.tls.TlsSRPLoginParameters;
import cn.org.bjca.gaia.crypto.tls.TlsSRPUtils;
import cn.org.bjca.gaia.crypto.tls.TlsSignerCredentials;
import cn.org.bjca.gaia.crypto.tls.TlsUtils;
import java.io.IOException;
import java.util.Hashtable;

public class SRPTlsServer
extends AbstractTlsServer {
    protected TlsSRPIdentityManager srpIdentityManager;
    protected byte[] srpIdentity = null;
    protected TlsSRPLoginParameters loginParameters = null;

    public SRPTlsServer(TlsSRPIdentityManager srpIdentityManager) {
        this(new DefaultTlsCipherFactory(), srpIdentityManager);
    }

    public SRPTlsServer(TlsCipherFactory cipherFactory, TlsSRPIdentityManager srpIdentityManager) {
        super(cipherFactory);
        this.srpIdentityManager = srpIdentityManager;
    }

    protected TlsSignerCredentials getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    protected int[] getCipherSuites() {
        return new int[]{49186, 49183, 49185, 49182, 49184, 49181};
    }

    @Override
    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        super.processClientExtensions(clientExtensions);
        this.srpIdentity = TlsSRPUtils.getSRPExtension(clientExtensions);
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        int cipherSuite = super.getSelectedCipherSuite();
        if (TlsSRPUtils.isSRPCipherSuite(cipherSuite)) {
            if (this.srpIdentity != null) {
                this.loginParameters = this.srpIdentityManager.getLoginParameters(this.srpIdentity);
            }
            if (this.loginParameters == null) {
                throw new TlsFatalAlert(115);
            }
        }
        return cipherSuite;
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 21: {
                return null;
            }
            case 22: {
                return this.getDSASignerCredentials();
            }
            case 23: {
                return this.getRSASignerCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 21: 
            case 22: 
            case 23: {
                return this.createSRPKeyExchange(keyExchangeAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int keyExchange) {
        return new TlsSRPKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.srpIdentity, this.loginParameters);
    }
}

