/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cert.ocsp;

import cn.org.bjca.gaia.asn1.DERNull;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.ocsp.ResponderID;
import cn.org.bjca.gaia.asn1.oiw.OIWObjectIdentifiers;
import cn.org.bjca.gaia.asn1.x500.X500Name;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.cert.ocsp.OCSPException;
import cn.org.bjca.gaia.operator.DigestCalculator;
import java.io.OutputStream;

public class RespID {
    public static final AlgorithmIdentifier HASH_SHA1 = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE);
    ResponderID id;

    public RespID(ResponderID id) {
        this.id = id;
    }

    public RespID(X500Name name) {
        this.id = new ResponderID(name);
    }

    public RespID(SubjectPublicKeyInfo subjectPublicKeyInfo, DigestCalculator digCalc) throws OCSPException {
        try {
            if (!digCalc.getAlgorithmIdentifier().equals(HASH_SHA1)) {
                throw new IllegalArgumentException("only SHA-1 can be used with RespID - found: " + digCalc.getAlgorithmIdentifier().getAlgorithm());
            }
            OutputStream digOut = digCalc.getOutputStream();
            digOut.write(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            digOut.close();
            this.id = new ResponderID(new DEROctetString(digCalc.getDigest()));
        }
        catch (Exception e) {
            throw new OCSPException("problem creating ID: " + e, e);
        }
    }

    public ResponderID toASN1Primitive() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RespID)) {
            return false;
        }
        RespID obj = (RespID)o;
        return this.id.equals(obj.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

