/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.structure;

import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1Set;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.cms.Attribute;
import cn.org.bjca.gaia.asn1.cms.AttributeTable;
import cn.org.bjca.gaia.asn1.cms.ContentInfo;
import cn.org.bjca.gaia.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.assemb.constant.AlgConstant;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.util.ASN1Util;
import cn.org.bjca.gaia.cert.X509CertificateHolder;
import cn.org.bjca.gaia.cms.CMSSignedData;
import cn.org.bjca.gaia.cms.SignerInformation;
import cn.org.bjca.gaia.cms.SignerInformationStore;
import cn.org.bjca.gaia.tsp.TimeStampToken;
import cn.org.bjca.gaia.tsp.TimeStampTokenInfo;
import cn.org.bjca.gaia.util.Store;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;

public class BjcaTimeStamp {
    private TimeStampToken timeStampToken = null;

    public BjcaTimeStamp(byte[] timeStamp) throws PkiException {
        try {
            ContentInfo info = ContentInfo.getInstance(ASN1Util.checkAndGetASN1Object(timeStamp));
            this.timeStampToken = new TimeStampToken(info);
        }
        catch (Exception e) {
            throw new PkiException("11014003", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25", e);
        }
    }

    public byte[] getTstInfo() throws PkiException {
        TimeStampTokenInfo timeStampInfo = this.timeStampToken.getTimeStampInfo();
        try {
            return timeStampInfo.getEncoded();
        }
        catch (IOException e) {
            throw new PkiException("11014003", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25", e);
        }
    }

    public byte[] getHashFromTst() {
        TimeStampTokenInfo timeStampInfo = this.timeStampToken.getTimeStampInfo();
        return timeStampInfo.getMessageImprintDigest();
    }

    public byte[] getHashFromAttribute() {
        CMSSignedData cmsSignedData = this.timeStampToken.toCMSSignedData();
        SignerInformationStore signerInfos = cmsSignedData.getSignerInfos();
        Collection<SignerInformation> signers = signerInfos.getSigners();
        SignerInformation next = signers.iterator().next();
        AttributeTable signedAttributes = next.getSignedAttributes();
        Attribute attribute = signedAttributes.get(PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
        ASN1Set attrValues = attribute.getAttrValues();
        DEROctetString objectAt = (DEROctetString)attrValues.getObjectAt(0);
        return objectAt.getOctets();
    }

    public String getHashAlg() throws PkiException {
        String hashAlg = null;
        TimeStampTokenInfo timeStampInfo = this.timeStampToken.getTimeStampInfo();
        ASN1ObjectIdentifier messageImprintAlgOID = timeStampInfo.getMessageImprintAlgOID();
        hashAlg = AlgConstant.convertOidToAlgName(messageImprintAlgOID);
        return hashAlg;
    }

    public Date getSignTime() {
        TimeStampTokenInfo timeStampInfo = this.timeStampToken.getTimeStampInfo();
        return timeStampInfo.getGenTime();
    }

    public byte[] getSignCert() throws PkiException {
        byte[] cert = null;
        Store<X509CertificateHolder> certificates = this.timeStampToken.getCertificates();
        if (this.timeStampToken.getCertificates().getMatches(null).size() != 0) {
            X509CertificateHolder certificateHolder = this.timeStampToken.getCertificates().getMatches(null).iterator().next();
            Certificate certificate = certificateHolder.toASN1Structure();
            try {
                cert = certificate.getEncoded();
            }
            catch (IOException e) {
                throw new PkiException("11014003", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25", e);
            }
        }
        return cert;
    }

    public byte[] getAttribute() throws PkiException {
        CMSSignedData cmsSignedData = this.timeStampToken.toCMSSignedData();
        SignerInformationStore signerInfos = cmsSignedData.getSignerInfos();
        Collection<SignerInformation> signers = signerInfos.getSigners();
        SignerInformation next = signers.iterator().next();
        try {
            return next.getEncodedSignedAttributes();
        }
        catch (IOException e) {
            throw new PkiException("11014003", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25", e);
        }
    }

    public byte[] getSignValue() {
        CMSSignedData cmsSignedData = this.timeStampToken.toCMSSignedData();
        SignerInformationStore signerInfos = cmsSignedData.getSignerInfos();
        Collection<SignerInformation> signers = signerInfos.getSigners();
        SignerInformation next = signers.iterator().next();
        return next.getSignature();
    }
}

