/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.ygsoft.ecp.service.tool.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import org.hibernate.engine.jdbc.BlobProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFTPChannel {
    private String host;
    private int port;
    private String username;
    private String password;
    private ChannelSftp sftp = null;
    private Session sshSession = null;

    protected SFTPChannel(String phost, int ppost, String puserName, String ppasswd) {
        this.host = phost;
        this.port = ppost;
        this.username = puserName;
        this.password = ppasswd;
    }

    public void connect() throws JSchException {
        JSch jsch = new JSch();
        this.sshSession = jsch.getSession(this.username, this.host, this.port);
        if (this.password != null) {
            this.sshSession.setPassword(this.password);
        }
        Properties sshConfig = new Properties();
        sshConfig.put("StrictHostKeyChecking", "no");
        this.sshSession.setConfig(sshConfig);
        this.sshSession.connect();
        Channel channel = this.sshSession.openChannel("sftp");
        channel.connect();
        this.sftp = (ChannelSftp)channel;
    }

    public void disconnect() {
        if (this.sftp != null && this.sftp.isConnected()) {
            this.sftp.disconnect();
        }
        if (this.sshSession != null && this.sshSession.isConnected()) {
            this.sshSession.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob downloadFile(String remotefileName) throws SftpException, IOException {
        Blob blob;
        block2: {
            InputStream inputStream = null;
            try {
                Blob blob2;
                inputStream = this.sftp.get(remotefileName);
                byte[] dataBytes = StreamUtil.getBytes(inputStream);
                blob = blob2 = BlobProxy.generateProxy((byte[])dataBytes);
                Object var7_6 = null;
                if (null == inputStream) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (null == inputStream) break block3;
                    inputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        return blob;
    }

    public InputStream getInputStream(String remotefileName) throws SftpException, IOException {
        return this.sftp.get(remotefileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String remotePath, String remoteFileName, File file) throws SftpException, IOException {
        boolean bl;
        block2: {
            FileInputStream in = null;
            try {
                this.createDir(remotePath);
                in = new FileInputStream(file);
                this.sftp.put((InputStream)in, remoteFileName);
                bl = true;
                Object var7_6 = null;
                if (in == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (in == null) break block3;
                    in.close();
                }
                throw throwable;
            }
            in.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String remotePath, String remoteFileName, Blob data) throws SQLException, SftpException, IOException {
        boolean bl;
        block2: {
            InputStream in = null;
            try {
                this.createDir(remotePath);
                in = data.getBinaryStream();
                this.sftp.put(in, remoteFileName);
                bl = true;
                Object var7_6 = null;
                if (in == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (in == null) break block3;
                    in.close();
                }
                throw throwable;
            }
            in.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String remotePath, String remoteFileName, InputStream in) throws SftpException, IOException {
        boolean bl;
        block2: {
            try {
                this.createDir(remotePath);
                this.sftp.put(in, remoteFileName);
                bl = true;
                Object var6_5 = null;
                if (in == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (in == null) break block3;
                    in.close();
                }
                throw throwable;
            }
            in.close();
        }
        return bl;
    }

    public boolean createDir(String createpath) throws SftpException {
        if (this.isDirExist(createpath)) {
            this.sftp.cd(createpath);
            return true;
        }
        String[] pathArry = createpath.split("/");
        StringBuffer filePath = new StringBuffer("/");
        for (String path : pathArry) {
            if (path.equals("")) continue;
            filePath.append(path + "/");
            if (this.isDirExist(filePath.toString())) {
                this.sftp.cd(filePath.toString());
                continue;
            }
            this.sftp.mkdir(filePath.toString());
            this.sftp.cd(filePath.toString());
        }
        this.sftp.cd(createpath);
        return true;
    }

    public boolean isDirExist(String directory) {
        boolean isDirExistFlag = false;
        try {
            SftpATTRS sftpATTRS = this.sftp.lstat(directory);
            isDirExistFlag = true;
            return sftpATTRS.isDir();
        }
        catch (Exception e) {
            if (e.getMessage().toLowerCase().equals("no such file")) {
                isDirExistFlag = false;
            }
            return isDirExistFlag;
        }
    }

    public void deleteSFTP(String deleteFile) throws SftpException {
        this.sftp.rm(deleteFile);
    }

    public Vector<?> listFiles(String directory) throws SftpException {
        return this.sftp.ls(directory);
    }
}

