/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import javax.naming.NamingException;
import org.springframework.jndi.JndiTemplate;

public final class JNDIUtil
implements IEcpToolLogic {
    private static final IEcpLog LOG = EcpLogFactory.getLog(JNDIUtil.class);
    private static final JndiTemplate JNDITEMPLATE = new JndiTemplate();
    private static Long waittime = 5000L;

    private JNDIUtil() {
    }

    public static JndiTemplate getJndiTemplate() {
        return JNDITEMPLATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getJndiObject(String jndiName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JNDIUtil.class.getClassLoader());
            Object object = JNDITEMPLATE.lookup(jndiName);
            Object var5_4 = null;
            Thread.currentThread().setContextClassLoader(loader);
            return object;
        }
        catch (NamingException e) {
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info("\u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u7684JNDI\u5bf9\u8c61,JNDI\u540d\u79f0[" + jndiName + "]");
                }
                Object var3_7 = null;
                Object var5_5 = null;
                Thread.currentThread().setContextClassLoader(loader);
                return var3_7;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                Thread.currentThread().setContextClassLoader(loader);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registJndi(String jndiName, Object regObj) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.sleep(waittime);
                Thread.currentThread().setContextClassLoader(JNDIUtil.class.getClassLoader());
                JNDITEMPLATE.bind(jndiName, regObj);
            }
            catch (Exception e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("\u65e0\u6cd5\u7ed1\u5b9aJNDI\u5bf9\u8c61,JNDI\u540d\u79f0[" + jndiName + "]" + e.getMessage());
                }
                Object var5_4 = null;
                Thread.currentThread().setContextClassLoader(loader);
            }
            Object var5_3 = null;
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Thread.currentThread().setContextClassLoader(loader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJndi(String jndiName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(JNDIUtil.class.getClassLoader());
                JNDITEMPLATE.unbind(jndiName);
            }
            catch (NamingException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("\u65e0\u6cd5\u79fb\u9664JNDI\u5bf9\u8c61,JNDI\u540d\u79f0[" + jndiName + "]" + e.getMessage());
                }
                Object var4_3 = null;
                Thread.currentThread().setContextClassLoader(loader);
            }
            Object var4_2 = null;
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Thread.currentThread().setContextClassLoader(loader);
            throw throwable;
        }
    }

    static {
        if (System.getProperty("jndi.wait.time") != null) {
            try {
                waittime = Long.parseLong(System.getProperty("jndi.reg.waittime"));
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
    }
}

