/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.servlet.ServletException;

public final class ExceptionUtil
implements IEcpToolLogic {
    private ExceptionUtil() {
    }

    public static Throwable getActualThrowable(Throwable e) {
        if (e instanceof InvocationTargetException) {
            return ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof ServletException) {
            return ((ServletException)e).getRootCause();
        }
        return e;
    }

    public static Throwable getCauseThrowable(Throwable e) {
        if (e instanceof InvocationTargetException) {
            return ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof ServletException) {
            return ((ServletException)e).getRootCause();
        }
        return e.getCause();
    }

    public static String getRootExceptionMessage(Throwable e) {
        Throwable root = ExceptionUtil.getRootThrowable(e);
        if (root instanceof NullPointerException) {
            return "\u5f15\u7528\u7684\u5bf9\u8c61\u4e3a\u7a7a:" + root.getMessage();
        }
        return root.getMessage();
    }

    public static String getTopAndRootExceptionMessage(Throwable e) {
        Throwable root = ExceptionUtil.getRootThrowable(e);
        Throwable top = ExceptionUtil.getActualThrowable(e);
        String rootMsg = root.getMessage();
        String topMsg = top.getMessage();
        if (root instanceof NullPointerException) {
            rootMsg = "\u5f15\u7528\u7684\u5bf9\u8c61\u4e3a\u7a7a:" + root.getMessage();
        }
        String msg = rootMsg != null && topMsg != null && topMsg.indexOf(rootMsg) == -1 ? topMsg + "\n" + rootMsg : (topMsg != null ? topMsg : rootMsg);
        return msg;
    }

    public static Throwable getRootThrowable(Throwable e) {
        Throwable pe = ExceptionUtil.getCauseThrowable(e);
        if (pe == null) {
            return e;
        }
        Throwable root = pe;
        pe = ExceptionUtil.getCauseThrowable(pe);
        while (pe != null) {
            root = pe;
            pe = ExceptionUtil.getCauseThrowable(pe);
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExceptionAllMessage(Throwable e) {
        PrintStream ps;
        ByteArrayOutputStream bai = new ByteArrayOutputStream();
        try {
            ps = new PrintStream((OutputStream)bai, false, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e);
        }
        e.printStackTrace(ps);
        try {
            String detailMessage;
            ps.flush();
            bai.flush();
            String string = detailMessage = bai.toString("UTF-8");
            return string;
        }
        catch (Exception e2) {
            String string = e2.getMessage();
            return string;
        }
        finally {
            StreamUtil.closeStream(ps);
            StreamUtil.closeStream(bai);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExcepitonAllStackTraceUseWeb(Throwable e) {
        PrintStream ps;
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        list.add(e);
        Throwable pe = ExceptionUtil.getCauseThrowable(e);
        while (pe != null) {
            list.add(pe);
            pe = ExceptionUtil.getCauseThrowable(pe);
        }
        ByteArrayOutputStream bai = new ByteArrayOutputStream();
        try {
            ps = new PrintStream((OutputStream)bai, false, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < list.size(); ++i) {
            Throwable tempe = (Throwable)list.get(i);
            ExceptionUtil.printStackTrace(ps, tempe);
        }
        try {
            bai.flush();
            ps.flush();
            String i = bai.toString("UTF-8");
            return i;
        }
        catch (Exception e2) {
            String string = ExceptionUtil.getExceptionAllMessage(e2);
            return string;
        }
        finally {
            StreamUtil.closeStream(ps);
            StreamUtil.closeStream(bai);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printStackTrace(PrintStream s, Throwable e) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println(e);
            StackTraceElement[] trace = e.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                s.println("\tat " + trace[i]);
            }
        }
    }

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ExceptionUtil.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        ExceptionUtil.handleUnexpectedException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ExceptionUtil.rethrowRuntimeException(ex.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        ExceptionUtil.handleUnexpectedException(ex);
    }

    private static void handleUnexpectedException(Throwable ex) {
        IllegalStateException isex = new IllegalStateException("Unexpected exception thrown");
        isex.initCause(ex);
        throw isex;
    }
}

