/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.internal.encode.EncodeContext;
import com.ygsoft.ecp.service.security.Blowfish;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StreamUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.exception.EncodeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public final class EncodeUtil
implements IEcpToolLogic {
    private static Blowfish cipher = null;
    private static final String BASE64SEP = "\r\n";
    private static final String EMPTYSTRING = "";
    private static final String ENCODENAME = "GBK";
    private static final int BUFFER_SIZE = 1024;

    private EncodeUtil() {
    }

    public static String deleteBase64Sep(String base64Str) {
        if (StringUtil.isEmptyString(base64Str)) {
            return base64Str;
        }
        return base64Str.replaceAll(BASE64SEP, EMPTYSTRING);
    }

    public static byte[] decodeToBytes(String base64String) {
        try {
            Object instance = ClassUtil.createObject("sun.misc.BASE64Decoder");
            Object result = ClassUtil.callMethod(instance, "decodeBuffer", new Object[]{base64String});
            return (byte[])result;
        }
        catch (Exception e) {
            throw new EncodeException("E0208.0013", e);
        }
    }

    public static void encodeStream(InputStream inputstream, OutputStream outputstream) {
        try {
            Object instance = ClassUtil.createObject("sun.misc.BASE64Encoder");
            ClassUtil.callMethod(instance, "encode", new Object[]{inputstream, outputstream});
        }
        catch (Exception e) {
            throw new EncodeException("E0208.0013", EcpI18nUtil.localizedString("E0208.0013", "\u7f16\u7801\u5931\u8d25"), e, new Object[0]);
        }
    }

    public static String encodeString(String plainText) {
        return EncodeUtil.encodeString(plainText, EncodeContext.getCurrentEncodeContext().getEncodeName());
    }

    public static String encodeString(String plainText, String charSet) {
        try {
            Object instance = ClassUtil.createObject("sun.misc.BASE64Encoder");
            Object result = ClassUtil.callMethod(instance, "encode", new Object[]{plainText.getBytes(charSet)});
            return result.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodeException("E0208.0013", EcpI18nUtil.localizedString("E0208.0013", "\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u96c6"), e, new Object[0]);
        }
    }

    public static byte[] encodeBytesToBytes(byte[] abyte0) {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0);
        byte[] s = null;
        try {
            Object instance = ClassUtil.createObject("sun.misc.BASE64Encoder");
            ClassUtil.callMethod(instance, "encode", new Object[]{bytearrayinputstream, bytearrayoutputstream});
            s = bytearrayoutputstream.toByteArray();
        }
        catch (Exception e) {
            throw new EncodeException("E0208.0013", EcpI18nUtil.localizedString("E0208.0013", "\u7f16\u7801\u5931\u8d25"), e, new Object[0]);
        }
        return s;
    }

    public static String encodeBytes(byte[] plainContent) {
        Object instance = ClassUtil.createObject("sun.misc.BASE64Encoder");
        String encodeName = EncodeContext.getCurrentEncodeContext().getEncodeName();
        if (ENCODENAME.equalsIgnoreCase(encodeName)) {
            Object result = ClassUtil.callMethod(instance, "encode", new Object[]{plainContent});
            return result.toString();
        }
        try {
            String tmpStr = new String(plainContent, encodeName);
            return EncodeUtil.encodeString(tmpStr);
        }
        catch (Exception e) {
            throw new EncodeException("E0208.0013", EcpI18nUtil.localizedString("E0208.0013", "\u7f16\u7801\u5931\u8d25"), e, new Object[0]);
        }
    }

    public static String encodeString(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        EncodeUtil.encodeStream(inputStream, outputStream);
        try {
            return outputStream.toString(EncodeContext.getCurrentEncodeContext().getEncodeName());
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodeException("E0208.0013", EcpI18nUtil.localizedString("E0208.0013", "\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u96c6"), e, new Object[0]);
        }
    }

    public static void decodeStream(InputStream inputstream, OutputStream outputstream) {
        try {
            Object instance = ClassUtil.createObject("sun.misc.BASE64Decoder");
            ClassUtil.callMethod(instance, "decodeBuffer", new Object[]{inputstream, outputstream});
        }
        catch (Exception e) {
            throw new EncodeException("E0208.0013", EcpI18nUtil.localizedString("E0208.0013", "\u89e3\u7801\u5931\u8d25"), e, new Object[0]);
        }
    }

    public static String decodeString(String encodedText) {
        return EncodeUtil.decodeString(encodedText, EncodeContext.getCurrentEncodeContext().getEncodeName());
    }

    public static String decodeString(String encodedText, String charSet) {
        try {
            Object instance = ClassUtil.createObject("sun.misc.BASE64Decoder");
            Object result = ClassUtil.callMethod(instance, "decodeBuffer", new Object[]{encodedText});
            return new String((byte[])result, charSet);
        }
        catch (Exception e) {
            throw new EncodeException("E0208.0013", EcpI18nUtil.localizedString("E0208.0013", "\u89e3\u7801\u5931\u8d25"), e, new Object[0]);
        }
    }

    public static String decodeStream(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        EncodeUtil.decodeStream(inputStream, outputStream);
        try {
            return outputStream.toString(EncodeContext.getCurrentEncodeContext().getEncodeName());
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodeException("E0208.0013", EcpI18nUtil.localizedString("E0208.0013", "\u89e3\u7801\u5931\u8d25"), e, new Object[0]);
        }
    }

    public static String zipAndEncodeString(String inStr) {
        String string;
        ByteArrayOutputStream dest = null;
        DeflaterOutputStream out = null;
        try {
            dest = new ByteArrayOutputStream();
            out = new DeflaterOutputStream(dest);
            String encodeName = EncodeContext.getCurrentEncodeContext().getEncodeName();
            out.write(inStr.getBytes(encodeName));
            out.finish();
            Object instance = ClassUtil.createObject("sun.misc.BASE64Encoder");
            byte[] bytes = dest.toByteArray();
            Object result = ClassUtil.callMethod(instance, "encode", new Object[]{bytes});
            string = result.toString();
            Object var9_9 = null;
        }
        catch (IOException e) {
            try {
                throw new EncodeException("E0208.0013", EcpI18nUtil.localizedString("E0208.0013", "\u538b\u7f29\u5b57\u7b26\u4e32\u5931\u8d25"), e, new Object[0]);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                StreamUtil.closeStream(out);
                StreamUtil.closeStream(dest);
                throw throwable;
            }
        }
        StreamUtil.closeStream(out);
        StreamUtil.closeStream(dest);
        return string;
    }

    public static String unzipAndDecodeString(String inStr) {
        String string;
        ByteArrayInputStream dest = null;
        InflaterInputStream in = null;
        try {
            Object instance = ClassUtil.createObject("sun.misc.BASE64Decoder");
            Object result = ClassUtil.callMethod(instance, "decodeBuffer", new Object[]{inStr});
            byte[] inByte = (byte[])result;
            dest = new ByteArrayInputStream(inByte);
            in = new InflaterInputStream(dest);
            int count = 0;
            byte[] bytes = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((count = in.read(bytes, 0, 1024)) != -1) {
                out.write(bytes, 0, count);
            }
            String encodeName = EncodeContext.getCurrentEncodeContext().getEncodeName();
            string = new String(out.toByteArray(), encodeName);
            Object var12_12 = null;
        }
        catch (IOException e) {
            try {
                throw new EncodeException("E0208.0013", EcpI18nUtil.localizedString("E0208.0013", "\u89e3\u7f29\u5b57\u7b26\u4e32\u5931\u8d25"), e, new Object[0]);
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                StreamUtil.closeStream(in);
                StreamUtil.closeStream(dest);
                throw throwable;
            }
        }
        StreamUtil.closeStream(in);
        StreamUtil.closeStream(dest);
        return string;
    }

    public static String encryptString(String encryptString) {
        if (encryptString == null) {
            return null;
        }
        EncodeUtil.getCipher();
        if (cipher == null) {
            throw new UnsupportedOperationException();
        }
        return cipher.encryptString(encryptString);
    }

    public static String decryptString(String decryptString) {
        if (decryptString == null) {
            return null;
        }
        EncodeUtil.getCipher();
        if (cipher == null) {
            throw new UnsupportedOperationException();
        }
        return cipher.decryptString(decryptString);
    }

    public static String encryptString(String encryptString, String key) {
        if (encryptString == null) {
            return null;
        }
        return new Blowfish(key).encryptString(encryptString);
    }

    public static String decryptString(String decryptString, String key) {
        if (decryptString == null) {
            return null;
        }
        return new Blowfish(key).decryptString(decryptString);
    }

    private static synchronized Blowfish getCipher() {
        if (cipher != null) {
            return cipher;
        }
        cipher = new Blowfish();
        return cipher;
    }
}

