/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.script;

import com.ygsoft.ecp.service.exception.ScriptException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.script.ScriptEvaluator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptEvaluator
implements ScriptEvaluator {
    private static final IEcpLog log = EcpLogFactory.getLog(JavaScriptEvaluator.class);
    private Context conext = null;
    private Scriptable scope = null;
    public static final URL javascriptUrl = null;
    private static String jsFileCache = null;

    @Override
    public boolean evaluateCondition(String condition, Map<String, Object> context) {
        if (condition == null || condition.trim().length() == 0) {
            return true;
        }
        Object eval = this.evaluateExpression(condition, context, Boolean.class);
        try {
            return (Boolean)eval;
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("JavaScriptEvaluator -> The result of condition " + condition + " cannot be converted to boolean");
            }
            throw new ScriptException("Result cannot be converted to boolean", ex);
        }
    }

    @Override
    public Object evaluateExpression(String expr, Map<String, Object> context, Class<?> resultClass) {
        Context cx = Context.enter();
        Scriptable scope = cx.initStandardObjects(null);
        try {
            this.prepareContext(scope, context);
            if (log.isDebugEnabled()) {
                log.debug("Evaluating javascript expression:" + expr);
            }
            Object eval = resultClass != null ? Context.toType((Object)cx.evaluateString(scope, expr, "", 1, null), resultClass) : cx.evaluateString(scope, expr, "", 1, null);
            if (log.isDebugEnabled()) {
                log.debug("JavaScriptEvaluator->Javascript expression " + expr + " is evaluated to " + eval);
            }
            Object object = eval;
            return object;
        }
        catch (Exception jse) {
            if (log.isErrorEnabled()) {
                log.error("JavaScriptEvaluator -> The result of expression " + expr + " can't be evaluated - error message=" + jse.getMessage(), jse);
            }
            throw new ScriptException("Result cannot be evaluated", jse);
        }
        finally {
            Context.exit();
        }
    }

    private void prepareContext(Scriptable scope, Map<String, Object> context) throws Exception {
        if (context == null) {
            return;
        }
        for (Map.Entry<String, Object> me : context.entrySet()) {
            scope.put(me.getKey(), scope, me.getValue());
        }
    }

    @Override
    public Object execute(String expr, Map<String, Object> context) {
        if (context == null || context.size() == 0) {
            return this.evaluateExpression(expr);
        }
        return this.evaluateExpression(expr, context, null);
    }

    @Override
    public void release() {
    }

    public Object evaluateExpression(String expr) {
        this.initJavaScriptContext();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Evaluating javascript expression:" + expr);
            }
            Object eval = this.conext.evaluateString(this.scope, expr, "", 1, null);
            if (log.isDebugEnabled()) {
                log.debug("JavaScriptEvaluator->Javascript expression " + expr + " is evaluated to " + eval);
            }
            Object object = eval;
            return object;
        }
        catch (Exception jse) {
            if (log.isErrorEnabled()) {
                log.error("JavaScriptEvaluator -> The result of expression " + expr + " can't be evaluated - error message=" + jse.getMessage(), jse);
            }
            throw new ScriptException("Result cannot be evaluated", jse);
        }
    }

    private void initJavaScriptContext() {
        block5: {
            if (this.conext == null) {
                this.conext = Context.enter();
                this.scope = this.conext.initStandardObjects(null);
                try {
                    if (javascriptUrl == null) {
                        return;
                    }
                    if (jsFileCache == null) {
                        jsFileCache = this.getJavaScriptContext();
                    }
                    this.conext.evaluateString(this.scope, jsFileCache, "", 1, null);
                }
                catch (JavaScriptException e) {
                    if (!log.isWarnEnabled()) break block5;
                    log.warn(e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJavaScriptContext() {
        LineNumberReader reader = null;
        InputStream io = null;
        try {
            io = javascriptUrl.openStream();
            reader = new LineNumberReader(new InputStreamReader(io, "GBK"));
            String str = "";
            StringBuffer buffer = new StringBuffer();
            while ((str = reader.readLine()) != null) {
                buffer.append(str).append("\n");
            }
            String string = buffer.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (io != null) {
                try {
                    io.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

