/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.log.memlog2;

import com.ygsoft.ecp.service.internal.log.answer.ErrorLogAnswer;
import com.ygsoft.ecp.service.internal.log.bean.UserLogInfo;
import com.ygsoft.ecp.service.internal.log.memlog2.MemoryLogControler;
import java.util.Map;
import java.util.WeakHashMap;
import org.springframework.beans.factory.InitializingBean;

public class MemoryLogAccessor
implements InitializingBean {
    Map<String, UserLogInfo> container = new WeakHashMap<String, UserLogInfo>();
    Map<String, StringBuffer> sqlContainer = new WeakHashMap<String, StringBuffer>();
    private MemoryLogControler controler;
    Map<String, StringBuffer> containerKey = new WeakHashMap<String, StringBuffer>();
    private ErrorLogAnswer errorLogAnswer;

    public void afterPropertiesSet() throws Exception {
        if (this.errorLogAnswer == null) {
            this.errorLogAnswer = new ErrorLogAnswer();
        }
    }

    public MemoryLogControler getControler() {
        if (null == this.controler) {
            this.controler = new MemoryLogControler(this);
        }
        return this.controler;
    }

    private StringBuffer getResultBuffer() {
        String ip = this.controler.getClientIP();
        StringBuffer grb = this.containerKey.get(ip);
        if (grb == null) {
            grb = new StringBuffer();
            this.containerKey.put(ip, grb);
        }
        return grb;
    }

    private UserLogInfo getUserInfoBuffer() {
        String ip = this.controler.getClientIP();
        UserLogInfo userLogInfo = this.container.get(ip);
        return userLogInfo;
    }

    private StringBuffer getSqlBuffer() {
        String ip = this.controler.getClientIP();
        StringBuffer sb = this.sqlContainer.get(ip);
        if (sb == null) {
            return new StringBuffer("\u5ba2\u6237\u7aef\u672a\u542f\u7528\u5185\u5b58\u65e5\u5fd7...\n");
        }
        return sb;
    }

    public void writeLog(String info, String orginalInfo) {
        if (this.getControler().isEnabled()) {
            UserLogInfo userLogInfo = this.getUserInfoBuffer();
            userLogInfo.write(info);
        }
    }

    public void writeSqlLog(String info, String orginalInfo) {
        if (this.getControler().isEnabled() && this.getUserInfoBuffer().isAddSqlLog()) {
            StringBuffer sb = this.getSqlBuffer();
            sb.append(info).append("\n");
        }
    }

    public String readResult() {
        if (this.getControler().isEnabled()) {
            StringBuffer sb = this.getResultBuffer();
            StringBuffer result = new StringBuffer();
            result.append("\u6b64\u95ee\u9898\u89e3\u51b3\u65b9\u6848\u8fd8\u6ca1\u6709\u603b\u7ed3\uff01\uff01");
            return result.toString();
        }
        return null;
    }

    public String read() {
        if (this.getControler().isEnabled()) {
            StringBuilder sb = this.getUserInfoBuffer().getAllLogInfo();
            return sb.toString();
        }
        return "\u8fd8\u672a\u4ea7\u751f\u5185\u5b58\u65e5\u5fd7...";
    }

    public String readSqlLog() {
        if (this.getControler().isEnabled()) {
            StringBuffer sb = this.getSqlBuffer();
            return sb.toString();
        }
        return null;
    }
}

