/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.log.memlog2;

import com.ygsoft.ecp.framework.token.TokenHolder;
import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.config.IApplicationConfig;
import com.ygsoft.ecp.service.config.INodeConfig;
import com.ygsoft.ecp.service.config.IUserConfig;
import com.ygsoft.ecp.service.internal.log.memlog2.MemoryLogAccessor;
import com.ygsoft.ecp.service.internal.log.memlog2.OutputBuilder;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.log.LogContextHolder;
import com.ygsoft.ecp.service.tool.FileUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.File;
import java.util.Enumeration;
import java.util.Locale;

public class DebugInfoOutputBuilder
implements OutputBuilder {
    private MemoryLogAccessor memoryLogAccessor;
    private static final IEcpLog LOG = EcpLogFactory.getLog(DebugInfoOutputBuilder.class);

    public void setMemoryLogAccessor(MemoryLogAccessor newmemoryLogAccessor) {
        this.memoryLogAccessor = newmemoryLogAccessor;
    }

    private String getLogRoot() {
        String userCode = LogContextHolder.INSTANCE.getUserId();
        if (StringUtil.isEmptyString(userCode)) {
            userCode = TokenHolder.INSTANCE.getToken();
        }
        if (StringUtil.isEmptyString(userCode)) {
            throw new RuntimeException("\u4e0d\u80fd\u521b\u5efa\u65e5\u5fd7,\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u7f16\u53f7,\u8bf7\u767b\u5f55\u7cfb\u7edf.");
        }
        String tempPath = System.getProperty("java.io.tmpdir");
        File tmpdir = new File(tempPath);
        boolean flag = true;
        if (!tmpdir.exists()) {
            flag = tmpdir.mkdirs();
        } else if (!tmpdir.canWrite()) {
            flag = false;
        }
        if (!flag) {
            throw new RuntimeException("\u4e0d\u80fd\u521b\u5efa\u65e5\u5fd7\u5b58\u653e\u4e34\u65f6\u76ee\u5f55");
        }
        File file = new File(tmpdir + File.separator + "ecp/logs", userCode);
        if (!file.exists()) {
            file.mkdirs();
            LOG.debug("create the log dir :" + file.getAbsolutePath());
        }
        return file.getAbsolutePath();
    }

    private void buildMemoryLog() {
        String memoryLog = this.memoryLogAccessor.read();
        if (memoryLog != null && memoryLog.trim().length() > 1) {
            File file = new File(this.getLogRoot() + "/memoryLog.txt");
            FileUtil.writeTextFile(file, memoryLog);
        }
    }

    private void buildUserContext() {
        String ip;
        StringBuilder sb = new StringBuilder();
        String string = LogContextHolder.INSTANCE.getIp() == null ? (TokenHolder.INSTANCE.getClientIP() == null ? "null" : TokenHolder.INSTANCE.getClientIP()) : (ip = LogContextHolder.INSTANCE.getIp());
        String username = LogContextHolder.INSTANCE.getUserName() == null ? (TokenHolder.INSTANCE.getToken() == null ? "null" : TokenHolder.INSTANCE.getToken()) : LogContextHolder.INSTANCE.getUserName();
        String loginorg = LogContextHolder.INSTANCE.getLoginOrgName() == null ? "null" : LogContextHolder.INSTANCE.getLoginOrgName();
        String dataorg = LogContextHolder.INSTANCE.getOrgName() == null ? "null" : LogContextHolder.INSTANCE.getOrgName();
        sb.append("\u5f53\u524d\u7528\u6237[IP=").append(ip).append(",\u7528\u6237\u540d\u79f0=").append(username).append(",\u767b\u5f55\u5355\u4f4d=").append(loginorg).append(",\u6570\u636e\u4e0a\u4e0b\u6587\u7ec4\u7ec7=").append(dataorg).append("]\r\n");
        File file = new File(this.getLogRoot() + "/userContext.txt");
        FileUtil.writeTextFile(file, sb.toString());
    }

    private void buildResultLog() {
        try {
            String resultLog = this.memoryLogAccessor.readResult();
            if (resultLog != null && resultLog.trim().length() > 1) {
                File file = new File(this.getLogRoot() + "/answerInfo.txt");
                FileUtil.writeTextFile(file, resultLog);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildServerInfo() {
        try {
            File file;
            block21: {
                INodeConfig nodeconf;
                block20: {
                    IUserConfig userconfig;
                    block19: {
                        file = new File(this.getLogRoot() + "/serverInfo.txt");
                        IApplicationConfig applicationconfig = EcpService.getConfigService().getApplicationConfig();
                        if (null != applicationconfig) {
                            StringBuilder sb = new StringBuilder("\u5e94\u7528\u914d\u7f6e:\n");
                            try {
                                Object var6_7;
                                try {
                                    this.formatStr(sb, "AbsoluteStoragePath", applicationconfig.getAbsoluteStoragePath());
                                    this.formatStr(sb, "AppId", applicationconfig.getAppId());
                                    this.formatStr(sb, "AppName", applicationconfig.getAppName());
                                    this.formatStr(sb, "StoragePath", applicationconfig.getStoragePath());
                                    Locale locale = applicationconfig.getLocale();
                                    this.formatStr(sb, "Charset", applicationconfig.getCharset().displayName(locale));
                                    this.formatStr(sb, "DatabaseType", applicationconfig.getDatabaseType().name());
                                    this.formatStr(sb, "Locale", applicationconfig.getLocale().getDisplayName(locale));
                                }
                                catch (Exception locale) {
                                    var6_7 = null;
                                    sb.append("\n\n=============================================\n\n\n");
                                    FileUtil.writeTextFile(file, sb.toString(), true);
                                    break block19;
                                }
                                var6_7 = null;
                                sb.append("\n\n=============================================\n\n\n");
                            }
                            catch (Throwable throwable) {
                                Object var6_8 = null;
                                sb.append("\n\n=============================================\n\n\n");
                                FileUtil.writeTextFile(file, sb.toString(), true);
                                throw throwable;
                            }
                            FileUtil.writeTextFile(file, sb.toString(), true);
                        }
                    }
                    if (null != (userconfig = EcpService.getConfigService().getCurrentUserConfig())) {
                        StringBuilder sb = new StringBuilder("\u672c\u8282\u70b9\u914d\u7f6e:\n");
                        try {
                            Object var8_13;
                            try {
                                this.formatStr(sb, "OwnerAppId", userconfig.getOwnerAppId());
                                this.formatStr(sb, "Locale", userconfig.getLocale());
                            }
                            catch (Exception exception) {
                                var8_13 = null;
                                sb.append("\n\n=============================================\n\n\n");
                                FileUtil.writeTextFile(file, sb.toString(), true);
                                break block20;
                            }
                            var8_13 = null;
                            sb.append("\n\n=============================================\n\n\n");
                        }
                        catch (Throwable throwable) {
                            Object var8_14 = null;
                            sb.append("\n\n=============================================\n\n\n");
                            FileUtil.writeTextFile(file, sb.toString(), true);
                            throw throwable;
                        }
                        FileUtil.writeTextFile(file, sb.toString(), true);
                    }
                }
                if (null != (nodeconf = EcpService.getConfigService().getNodeConfig())) {
                    StringBuilder sb = new StringBuilder("\u672c\u8282\u70b9\u914d\u7f6e:\n");
                    try {
                        Object var10_17;
                        try {
                            this.formatStr(sb, "IpAddress", nodeconf.getIpAddress());
                            this.formatStr(sb, "StorageRootPath", nodeconf.getStorageRootPath());
                            this.formatStr(sb, "Topic", nodeconf.getTopic());
                            this.formatStr(sb, "Port", nodeconf.getPort());
                            this.formatStr(sb, "ServerType", nodeconf.getServerType().name());
                            this.formatStr(sb, "OperatorSystemType", nodeconf.getOperatorSystemType().name());
                        }
                        catch (Exception exception) {
                            var10_17 = null;
                            sb.append("\n\n=============================================\n\n\n");
                            FileUtil.writeTextFile(file, sb.toString(), true);
                            break block21;
                        }
                        var10_17 = null;
                        sb.append("\n\n=============================================\n\n\n");
                    }
                    catch (Throwable throwable) {
                        Object var10_18 = null;
                        sb.append("\n\n=============================================\n\n\n");
                        FileUtil.writeTextFile(file, sb.toString(), true);
                        throw throwable;
                    }
                    FileUtil.writeTextFile(file, sb.toString(), true);
                }
            }
            Enumeration<?> proNames = System.getProperties().propertyNames();
            StringBuilder sb = new StringBuilder("\u7cfb\u7edf\u5c5e\u6027:\n");
            while (true) {
                if (!proNames.hasMoreElements()) {
                    FileUtil.writeTextFile(file, sb.toString(), true);
                    return;
                }
                String key = (String)proNames.nextElement();
                String value = System.getProperty(key);
                this.formatStr(sb, key, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void formatStr(StringBuilder sb, String key, Object value) {
        String ws = "                                                             ";
        sb.append("\t[");
        sb.append(key).append("                                                             ".substring(key.length() + 1));
        sb.append("]:").append("\t\t\t").append(value).append('\n');
    }

    public void build() {
        this.buildMemoryLog();
        this.bulidSqlMesLog();
        this.buildUserContext();
        this.buildServerInfo();
        this.buildResultLog();
    }

    public void deleteDir() {
        File file = new File(this.getLogRoot());
        if (file != null && file.exists()) {
            this.deleteFile(file);
        }
    }

    private void deleteFile(File file) {
        File[] files;
        if (file.isDirectory() && null != (files = file.listFiles()) && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                this.deleteFile(files[i]);
            }
        }
        file.delete();
    }

    private void bulidSqlMesLog() {
        try {
            String sqlLog = this.memoryLogAccessor.readSqlLog();
            if (sqlLog != null && (long)sqlLog.trim().length() > 0L) {
                File file = new File(this.getLogRoot() + "/sqlMesLog.txt");
                FileUtil.writeTextFile(file, sqlLog);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getProduce() {
        return this.getLogRoot();
    }

    public void build(String newArg0) {
    }
}

