/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.log;

import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class EcpLogUtils {
    private static final IEcpLog LOG = EcpLogFactory.getLog(EcpLogUtils.class);

    private EcpLogUtils() {
    }

    public static String getExceptionDetail(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static Object handleAndLogException(Throwable e) {
        Throwable ex = EcpLogUtils.getActualCause(e);
        if (LOG.isErrorEnabled()) {
            LOG.error(ex.getMessage(), ex);
        }
        return EcpLogUtils.handleException(ex);
    }

    private static Throwable getActualCause(Throwable e) {
        return e;
    }

    public static Object handleException(Throwable e) {
        Throwable ex = EcpLogUtils.getActualCause(e);
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new RuntimeException(ex);
    }
}

