/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.log;

import com.ygsoft.ecp.service.internal.log.EcpLogImpl;
import com.ygsoft.ecp.service.internal.log.memlog2.MemoryLogAccessor;
import com.ygsoft.ecp.service.log.IEcpBizLog;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.JSONUtil;
import java.text.MessageFormat;
import java.util.HashMap;

public class EcpBizLogImpl
implements IEcpBizLog {
    private IEcpLog ecpLog;
    private String logCls;
    private static MemoryLogAccessor memoryLogAccessor;

    public EcpBizLogImpl() {
    }

    public EcpBizLogImpl(IEcpLog log, String clsName) {
        this.ecpLog = log;
        this.logCls = clsName;
    }

    public void bizStart(String newBizName, String[] newParamNames, Object ... newArgs) {
        String message = null;
        String clName = "NoClassName";
        if (this.logCls != null) {
            clName = ClassUtil.getClassSimpleName(this.logCls);
        }
        if (newParamNames != null) {
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            for (int i = 0; i < newParamNames.length; ++i) {
                if (newArgs != null && i < newArgs.length) {
                    infoMap.put(newParamNames[i], newArgs[i]);
                    continue;
                }
                infoMap.put(newParamNames[i], "\u65e5\u5fd7\u8bb0\u5f55\u65f6\u6ca1\u6709\u4f20\u5165\u76f8\u5e94\u7684\u53c2\u6570");
            }
            message = MessageFormat.format("<bizLog cl=\"{0}.{1}\">{1} start,parameters:[ps]{2}[/ps]</bizLog>", clName, newBizName, JSONUtil.toJsonString(infoMap));
        } else {
            message = MessageFormat.format("<bizLog cl=\"{0}.{1}\">{1} start,parameters:[ps]{2}[/ps]</bizLog>", clName, newBizName, "\u65e5\u5fd7\u8bb0\u5f55\u65f6\u6ca1\u6709\u4f20\u5165\u76f8\u5e94\u7684\u53c2\u6570");
        }
        this.ecpLog.start(message);
    }

    public void bizEnd(String newBizName, Object newResult) {
        String clName = "NoClassName";
        if (this.logCls != null) {
            clName = ClassUtil.getClassSimpleName(this.logCls);
        }
        StringBuilder builder = new StringBuilder();
        String message1 = MessageFormat.format("<bizLog cl=\"{0}.{1}\">{1} end. ", clName, newBizName);
        builder.append(message1);
        builder.append(MessageFormat.format("used time: [t]{0}[/t] ,", ((EcpLogImpl)this.ecpLog).getEndTime()));
        if (newResult != null) {
            builder.append(MessageFormat.format("result:[r]{0}[/r]</bizLog>", JSONUtil.toJsonString(newResult)));
        } else {
            builder.append(MessageFormat.format("result:[r]{0}[/r]</bizLog>", "void or null"));
        }
        this.ecpLog.end(builder.toString());
    }

    public void bizLog(String newMessage, Object ... newArgs) {
        String message = newMessage;
        if (newArgs != null && newArgs.length > 0) {
            message = message + JSONUtil.toJsonString(newArgs);
        }
        this.ecpLog.info(MessageFormat.format("<bizLog>{0}</bizLog>", message));
    }

    public MemoryLogAccessor getMemoryLogAccessor() {
        return memoryLogAccessor;
    }

    public void setMemoryLogAccessor(MemoryLogAccessor newMemoryLogAccessor) {
        memoryLogAccessor = newMemoryLogAccessor;
    }

    public boolean isBizLogEnabled() {
        return "true".equalsIgnoreCase(System.getProperty("bizlogenabled")) || memoryLogAccessor != null && memoryLogAccessor.getControler().isEnabled();
    }
}

