/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.i18n;

import com.ygsoft.ecp.framework.spring.SpringContextHolder;
import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.cache.ICache;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.model.IValueObject;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.I18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceAccessService {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ResourceAccessService.class);
    private static final Map<String, Map<String, Object>> RES_MAP = new ConcurrentHashMap<String, Map<String, Object>>();
    private static final Map<String, Map<String, Object>> RES_CONFIG_MAP = new ConcurrentHashMap<String, Map<String, Object>>();
    private static ICache<String, Object> resourceCache = EcpService.getLRUCache("resourceCache");
    private static ICache<String, Object> configResourceCache = EcpService.getLRUCache("configResourceCache");
    static Class<?> dataModelUtil;

    public static Map<String, Map<String, Object>> getResMap() {
        return RES_MAP;
    }

    public static Map<String, Map<String, Object>> getResConfigMap() {
        return RES_CONFIG_MAP;
    }

    private ResourceAccessService() {
    }

    public static String getResource(Locale locale, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        String cacheKey = ResourceAccessService.getCacheKey(locale, key);
        if (resourceCache.containsKey(cacheKey)) {
            return (String)resourceCache.get(cacheKey);
        }
        String value = (String)I18nUtil.getResource(RES_MAP, locale, key);
        if (value != null) {
            resourceCache.put(cacheKey, value);
        } else {
            try {
                value = SpringContextHolder.INSTANCE.getMessageSource().getMessage(key, null, locale);
            }
            catch (NoSuchMessageException noSuchMessageException) {
                // empty catch block
            }
        }
        return value;
    }

    private static String getCacheKey(Locale locale, String key) {
        return I18nUtil.getLocaleStr(locale) + key;
    }

    public static void putResource(Bundle bundle, String path) {
        if (StringUtils.isEmpty((Object)path) || bundle == null) {
            return;
        }
        I18nUtil.putOrRemoveResource(RES_MAP, bundle, path, "", false);
    }

    public static void removeResource(Bundle bundle, String path) {
        if (StringUtils.isEmpty((Object)path) || bundle == null) {
            return;
        }
        I18nUtil.putOrRemoveResource(RES_MAP, bundle, path, "", true);
    }

    public static void putDataModelResource(Bundle bundle, String path) {
        if (StringUtils.isEmpty((Object)path) || bundle == null) {
            return;
        }
        I18nUtil.putOrRemoveResource(RES_CONFIG_MAP, bundle, path, "#", false);
    }

    public static void removeDataModelResource(Bundle bundle, String path) {
        if (StringUtils.isEmpty((Object)path) || bundle == null) {
            return;
        }
        I18nUtil.putOrRemoveResource(RES_CONFIG_MAP, bundle, path, "#", true);
    }

    public static void clearResource() {
        if (LOG.isInfoEnabled()) {
            LOG.info("\u79fb\u9664\u5168\u90e8\u56fd\u9645\u5316\u8d44\u6e90");
        }
        RES_MAP.clear();
    }

    public static String getResourceBatch(Locale locale, String template) {
        return I18nUtil.convert(locale, template, RES_MAP);
    }

    public static <V extends IValueObject> V getResourceMessage(Locale locale, V dataModel, String uri) {
        if (dataModel == null || StringUtil.isEmpty(uri)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u6570\u636e\u6a21\u578b\u4e3anull\u6216uri\u4e3anull,\u8bf7\u68c0\u67e5");
            }
            return null;
        }
        String localeStr = I18nUtil.getLocaleStr(locale);
        Map<String, Object> map = RES_CONFIG_MAP.get(localeStr);
        if (map != null) {
            Map resourceMap = (Map)map.get(uri);
            if (resourceMap != null) {
                ResourceAccessService.convert(dataModel, resourceMap, localeStr + uri);
            } else if (LOG.isInfoEnabled()) {
                LOG.info("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u8bed\u8a00\u4e0b\u7684\u6307\u5b9auri\u7684\u56fd\u9645\u5316\u8d44\u6e90,localeStr=" + localeStr + ",uri=" + uri);
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u8bed\u8a00\u7684\u56fd\u9645\u5316\u8d44\u6e90,locale=" + localeStr);
        }
        return dataModel;
    }

    private static <V extends IValueObject> void convert(V dataModel, Map<String, Object> resourceMap, String prefix) {
        Iterator<String> it = resourceMap.keySet().iterator();
        String key = null;
        Object value = null;
        String cacheKey = null;
        while (it.hasNext()) {
            key = it.next();
            cacheKey = prefix + key;
            if (configResourceCache.containsKey(cacheKey)) {
                value = configResourceCache.get(cacheKey);
            } else {
                value = resourceMap.get(key);
                if (value != null) {
                    configResourceCache.put(cacheKey, value);
                }
            }
            if (value == null) continue;
            try {
                Object element = null;
                String attrName = key;
                if (key.indexOf(".") != -1) {
                    element = ResourceAccessService.getAttributeValue(dataModel, key);
                    attrName = key.substring(key.lastIndexOf(".") + 1);
                } else {
                    element = dataModel;
                }
                if (element instanceof Map) {
                    ((Map)element).put(attrName, value);
                    continue;
                }
                ResourceAccessService.setAttribute(new Object[]{element, attrName, value});
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("\u6570\u636e\u6a21\u578b\u56fd\u9645\u5316\u8bbe\u7f6e\u5c5e\u6027\u503c\u51fa\u9519,key=" + key + ",value=" + value);
            }
        }
    }

    private static void setAttribute(Object[] args) {
        ClassUtil.callMethod(dataModelUtil, "setAttribute", args);
    }

    private static Object getAttributeValue(Object obj, String attr) {
        Object res = null;
        int pos = attr.indexOf(".");
        String before = attr.substring(0, pos);
        String after = attr.substring(pos + 1);
        String findRegex = "\\[\\w*\\]";
        String replaceRegex = "[\\[|\\]]";
        Object value = ResourceAccessService.getFirstLevelObj(obj, before, "\\[\\w*\\]");
        if (after.indexOf(".") != -1) {
            if (value instanceof List) {
                Matcher m = Pattern.compile("\\[\\w*\\]").matcher(before);
                if (m.find()) {
                    String realKey = m.group(0).replaceAll("[\\[|\\]]", "");
                    res = ResourceAccessService.getAttributeValue(((List)value).get(Integer.parseInt(realKey)), after);
                }
            } else {
                res = ResourceAccessService.getAttributeValue(value, after);
            }
        } else {
            res = ResourceAccessService.findByRegex("\\[\\w*\\]", before) ? ResourceAccessService.getLastLevelObj(value, before, "\\[\\w*\\]", "[\\[|\\]]") : value;
        }
        return res;
    }

    private static boolean findByRegex(String regex, String str) {
        return Pattern.compile(regex).matcher(str).find();
    }

    private static Object getLastLevelObj(Object parentObj, String key, String findRegex, String replaceRegex) {
        Object res = null;
        List list = (List)parentObj;
        Matcher m = Pattern.compile(findRegex).matcher(key);
        if (m.find()) {
            String itemName = m.group(0).replaceAll(replaceRegex, "");
            boolean find = false;
            Object item = null;
            String id = null;
            for (int i = 0; i < list.size(); ++i) {
                item = list.get(i);
                String name = (String)ResourceAccessService.getAttribute(new Object[]{item, "name"});
                String gid = (String)ResourceAccessService.getAttribute(new Object[]{item, "gid"});
                id = (String)ResourceAccessService.getAttribute(new Object[]{item, "id"});
                if (!("" + itemName).equals("" + name) && !("" + itemName).equals("" + gid) && !("" + itemName).equals("" + id)) continue;
                res = list.get(i);
                find = true;
                break;
            }
            if (!find) {
                res = list.get(Integer.parseInt(itemName));
            }
        }
        return res;
    }

    private static Object getFirstLevelObj(Object obj, String key, String findRegex) {
        String realKey = key.replaceAll(findRegex, "");
        Object value = obj instanceof Map ? ((Map)obj).get(realKey) : ResourceAccessService.getAttribute(new Object[]{obj, realKey});
        return value;
    }

    private static Object getAttribute(Object[] args) {
        try {
            return ClassUtil.callMethod(dataModelUtil, "getAttribute", args);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void initDataModelUtil() {
        block2: {
            try {
                dataModelUtil = ClassUtil.getClass("com.ygsoft.ecp.core.framework.tool.DataModelUtil");
            }
            catch (ClassNotFoundException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("\u901a\u8fc7\u53cd\u5c04\u65e0\u6cd5\u751f\u6210DataModelUtil\u5bf9\u8c61");
            }
        }
    }

    static {
        ResourceAccessService.initDataModelUtil();
    }
}

