/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.config;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.config.DatabaseType;
import com.ygsoft.ecp.service.config.IApplicationConfig;
import com.ygsoft.ecp.service.internal.storage.StorageUtil;
import com.ygsoft.ecp.service.model.ConfigItem;
import com.ygsoft.ecp.service.tool.MutilingualUtil;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationConfig
implements IApplicationConfig {
    public static final ApplicationConfig INSTANCE = new ApplicationConfig();
    private static final long serialVersionUID = 1L;
    private String appName;
    private String appId;
    private Locale locale;
    private boolean localeEnable;
    private Locale defaultLocale;
    private Charset charset = Charset.forName("UTF-8");
    private DatabaseType databaseType;
    private String storagePath;

    private ApplicationConfig() {
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    void setAppName(String newappName) {
        this.appName = newappName;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.SIMPLIFIED_CHINESE;
        }
        return this.locale;
    }

    void setLocale(Locale newlocale) {
        this.locale = newlocale;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    void setCharset(Charset newcharset) {
        this.charset = newcharset;
    }

    @Override
    public String getAppId() {
        if (this.appId == null) {
            this.appId = "00000000000000000000000000000000";
        }
        return this.appId;
    }

    public void setAppId(String newappId) {
        this.appId = newappId;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(DatabaseType newdatabaseType) {
        this.databaseType = newdatabaseType;
    }

    @Override
    public String getAbsoluteStoragePath() {
        String nodepath = EcpService.getConfigService().getNodeConfig().getStorageRootPath();
        return StorageUtil.comboPath(nodepath, this.getStoragePath());
    }

    @Override
    public String getStoragePath() {
        if (this.storagePath == null) {
            this.storagePath = this.getAppId();
        }
        return this.storagePath;
    }

    public void setStoragePath(String newstoragePath) {
        this.storagePath = newstoragePath;
    }

    @Override
    public List<ConfigItem> getConfigItemList(String topicName) {
        return null;
    }

    @Override
    public boolean isLocaleEnable() {
        this.localeEnable = MutilingualUtil.isLocaleEnable();
        return this.localeEnable;
    }

    public void setLocaleEnable(boolean newLocaleEnable) {
        this.localeEnable = newLocaleEnable;
    }

    @Override
    public Locale getDefaultLocale() {
        if (this.defaultLocale == null) {
            this.defaultLocale = MutilingualUtil.getDefaultLocale();
        }
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale newDefaultLocale) {
        this.defaultLocale = newDefaultLocale;
    }
}

