/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.log;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.ClassUtil;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ShardedJedis;

public final class RedisClient {
    private static final IEcpLog LOG = EcpLogFactory.getLog(RedisClient.class);
    private static final String REDIS_CLIENT_FACTORY = "com.ygsoft.ecp.service.cache.impl.redis.RedisClientFactory";
    private Object client = null;
    static final RedisClient INSTANCE = new RedisClient();

    private RedisClient() {
        Class cls = null;
        try {
            cls = ClassUtil.getClass(REDIS_CLIENT_FACTORY);
        }
        catch (ClassNotFoundException e) {
            LOG.error("\u7c7b[com.ygsoft.ecp.service.cache.impl.redis.RedisClientFactory]\u6ca1\u6709\u627e\u5230!");
        }
        this.client = ClassUtil.getStaticAttribute(cls, "INSTANCE", false);
    }

    protected boolean isSharedConnection() {
        return (Boolean)ClassUtil.callMethod(this.client, "isSharedConnection", new Object[0]);
    }

    protected Jedis getConnection() {
        return (Jedis)ClassUtil.callMethod(this.client, "getConnection", new Object[0]);
    }

    protected ShardedJedis getSharedConnection() {
        return (ShardedJedis)ClassUtil.callMethod(this.client, "getSharedConnection", new Object[0]);
    }

    protected void returnShareConnection(ShardedJedis sharedJedis) {
        ClassUtil.callMethod(this.client, "returnShareConnection", new Object[]{sharedJedis});
    }

    protected void returnConnection(Jedis jedis) {
        ClassUtil.callMethod(this.client, "returnConnection", new Object[]{jedis});
    }

    protected String genKey(String cacheName, String key) {
        if (cacheName == null || key == null) {
            throw new RuntimeException("\u7f13\u5b58\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return this.getDomainId() + "#" + cacheName + "#" + key;
    }

    protected String getDomainId() {
        return EcpService.getConfigService().getApplicationConfig().getAppId();
    }
}

