/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.engine;

import com.ygsoft.ecp.service.datasource.DataSourceSwapper;
import com.ygsoft.ecp.service.executor.DefaultServiceMessage;
import com.ygsoft.ecp.service.executor.ServiceMessage;
import com.ygsoft.ecp.service.executor.SystemException;
import com.ygsoft.ecp.service.executor.engine.ServiceHandler;
import com.ygsoft.ecp.service.executor.engine.SessionServiceFilter;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.webservice.WebServiceUtil;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebServiceHandler
implements ServiceHandler {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String ECP_SERVICES_PROFIX = "/grm/";
    private static final String YGFMISWEB_PROFIX = "/ygfmisweb/";
    private static final String FMISWEB_PROFIX = "/fmisweb/";
    private static final String YGLEADERQUERYWEB_PROFIX = "/ygleaderqueryweb/";
    private static final String WS_CALLER = "com.ygsoft.ecp.service.ws.client.WSCaller";
    private static final String SOAWARE_PROFIX = "soaware";

    public ServiceMessage service(ServiceMessage request) throws Exception {
        Object url;
        block16: {
            DefaultServiceMessage response = new DefaultServiceMessage();
            boolean flag = request.get("SESSION_FILTER_FLAG") != null;
            try {
                this.log.info((Object)Thread.currentThread().getName());
                if ("remote".equals(request.getServiceType()) && StringUtil.isNotEmpty(request.getServiceCode()) && StringUtil.isNotEmpty(request.getServiceName())) {
                    url = request.getServiceCode();
                    this.log.info((Object)("remote service url: " + (String)url));
                    String lower = ((String)url).toLowerCase();
                    if (lower.indexOf(ECP_SERVICES_PROFIX) > -1) {
                        Object result = this.callCxfWebservice(request, (String)url);
                        response.setContent(result);
                    } else if (lower.indexOf(YGFMISWEB_PROFIX) > -1 || lower.indexOf(FMISWEB_PROFIX) > -1 || lower.indexOf(YGLEADERQUERYWEB_PROFIX) > -1 || lower.indexOf(SOAWARE_PROFIX) > -1) {
                        WebServiceUtil client = new WebServiceUtil();
                        client.setUrl((String)url);
                        response.setContent(client.callMethod(request.getServiceName(), request.getParameters()));
                    } else {
                        Object result = this.callCxfWebservice(request, (String)url);
                        response.setContent(result);
                    }
                    if (flag) {
                        SessionServiceFilter.clearSessionAndDataBus(request);
                    }
                }
                url = response;
                Object var8_12 = null;
                DataSourceSwapper.INSTANCE.set(null);
                if (!flag) break block16;
            }
            catch (Throwable t) {
                try {
                    this.log.error((Object)("Invoke remote service:" + request.getServiceCode() + " failed!"), t);
                    SystemException e = null;
                    if (t instanceof SystemException) {
                        e = (SystemException)t;
                    } else if (t instanceof InvocationTargetException) {
                        Throwable throwable = ((InvocationTargetException)t).getCause();
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                    } else {
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        e = new SystemException(t);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    block17: {
                        Object var8_13 = null;
                        DataSourceSwapper.INSTANCE.set(null);
                        if (!flag) break block17;
                        SessionServiceFilter.clearSessionAndDataBus(request);
                    }
                    throw throwable;
                }
            }
            SessionServiceFilter.clearSessionAndDataBus(request);
        }
        return url;
    }

    private Object callCxfWebservice(ServiceMessage request, String url) {
        Class cls = null;
        try {
            cls = ClassUtil.getClass(WS_CALLER);
        }
        catch (Throwable e) {
            return null;
        }
        Object result = ClassUtil.callMethod(cls, "call", new Object[]{url, request.getServiceName(), request.getParameters()});
        return result;
    }
}

