/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.engine;

import com.ygsoft.ecp.framework.util.ClassUtil;
import com.ygsoft.ecp.service.executor.SystemException;
import com.ygsoft.ecp.service.executor.engine.CallableAwareFutureTask;
import com.ygsoft.ecp.service.executor.engine.IThreadPoolAopHandler;
import com.ygsoft.ecp.service.executor.engine.ServiceExecution;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolExecutorAopSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolExecutorAopSupport.class);
    private static final String WARN_MSG = "\u7ebf\u7a0b\u6c60\u5185\u7684\u5f02\u5e38\u5c06\u5bfc\u81f4\u7ebf\u7a0b\u53d8\u91cf\u4f20\u9012\u53ca\u6e05\u7406\u673a\u5236\u8fd0\u884c\u5931\u6548\uff0c\u4e3a\u4fdd\u8bc1\u4e1a\u52a1\u5b8c\u6574\u6027\uff0c\u6846\u67b6\u5df2\u4e3b\u52a8\u7ed3\u675f\u5f53\u524d\u5b50\u7ebf\u7a0b\uff0c\u5916\u5c42\u4e3b\u7ebf\u7a0b\u5c06\u8868\u73b0\u51fa\u957f\u65f6\u95f4\u6ca1\u6709\u54cd\u5e94\uff0c\u5e76\u5728\u8d85\u65f6\u65f6\u95f4\u5230\u8fbe\u5230\u540e\u62a5\u9519.";
    private static List<IThreadPoolAopHandler> aopHandlers;

    private static void loadRoundHandlers() {
        List regHandlers = ClassUtil.findObjectByInterface(IThreadPoolAopHandler.class);
        if (regHandlers == null || regHandlers.size() == 0) {
            aopHandlers = null;
            return;
        }
        Iterator iterator = regHandlers.iterator();
        while (iterator.hasNext()) {
            IThreadPoolAopHandler handler = (IThreadPoolAopHandler)iterator.next();
            if (handler.enabled()) continue;
            iterator.remove();
        }
        aopHandlers = regHandlers.size() == 0 ? null : regHandlers;
    }

    private static Map<String, Object> getMessageProperties(Runnable runnable) {
        if (runnable instanceof CallableAwareFutureTask) {
            CallableAwareFutureTask futureTask = (CallableAwareFutureTask)runnable;
            Object wrappedTask = ClassUtil.getFieldValue(futureTask.getCallable(), (String)"val$task");
            if (wrappedTask instanceof ServiceExecution) {
                return ((ServiceExecution)wrappedTask).getMessage().getProperties();
            }
            if (futureTask.getCallable() instanceof ServiceExecution) {
                return ((ServiceExecution)futureTask.getCallable()).getMessage().getProperties();
            }
        }
        SystemException exception = new SystemException("\u6267\u884cgetMessageProperties\u5931\u8d25\uff1a\u672a\u627e\u5230\u7ebf\u7a0b\u4e0a\u4e0b\u6587\u5c5e\u6027\u96c6.runable=" + runnable);
        if (LOG.isErrorEnabled()) {
            LOG.error("", (Throwable)exception);
        }
        throw exception;
    }

    public static void doBeforeDispatch(Map<String, Object> messageProps) {
        if (aopHandlers != null) {
            for (IThreadPoolAopHandler handler : aopHandlers) {
                try {
                    handler.beforeDispatch(messageProps);
                }
                catch (Throwable e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error("\u6267\u884c" + handler.getClass().getName() + ".doBeforeDispatch\u5931\u8d25. messageProps=" + messageProps, e);
                }
            }
        }
    }

    public static void doBeforeExecute(Thread t, Runnable r, Map<String, Object> messageProps) {
        if (aopHandlers != null) {
            for (IThreadPoolAopHandler handler : aopHandlers) {
                try {
                    handler.beforeExecute(t, t, messageProps);
                }
                catch (Throwable e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("\u6267\u884c" + handler.getClass().getName() + ".doBeforeExecute\u5931\u8d25. messageProps=" + messageProps + ". " + WARN_MSG, e);
                    }
                    throw new SystemException(e);
                }
            }
        }
    }

    public static void doBeforeExecute(Thread t, Runnable r) {
        if (aopHandlers != null) {
            Map<String, Object> messageProps = ThreadPoolExecutorAopSupport.getMessageProperties(r);
            ThreadPoolExecutorAopSupport.doBeforeExecute(t, r, messageProps);
        }
    }

    public static void doAfterExecute(Runnable r, Throwable t, Map<String, Object> messageParams) {
        if (aopHandlers != null) {
            for (IThreadPoolAopHandler handler : aopHandlers) {
                try {
                    handler.afterExecute(r, t, messageParams);
                }
                catch (Throwable e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("\u6267\u884c" + handler.getClass().getName() + ".doAfterExecute\u5931\u8d25. messageProps=" + messageParams + ". " + WARN_MSG, e);
                    }
                    throw new SystemException(e);
                }
            }
        }
    }

    public static void doAfterExecute(Runnable r, Throwable t) {
        if (aopHandlers != null) {
            Map<String, Object> messageParams = ThreadPoolExecutorAopSupport.getMessageProperties(r);
            ThreadPoolExecutorAopSupport.doAfterExecute(r, t, messageParams);
        }
    }

    static {
        ThreadPoolExecutorAopSupport.loadRoundHandlers();
    }
}

