/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.exception;

import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import java.text.MessageFormat;

public class EcpException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String errorCode;

    public EcpException(String newerrorCode, String message, Object ... messageParams) {
        super(MessageFormat.format(message, messageParams));
        this.errorCode = newerrorCode;
    }

    public EcpException(EcpException cause) {
        super(cause);
    }

    public EcpException(String newerrorCode, Throwable cause) {
        super(cause);
        this.errorCode = newerrorCode;
    }

    public EcpException(String newerrorCode, String message, Throwable cause, Object ... messageParams) {
        super(MessageFormat.format(message, messageParams), cause);
        this.errorCode = newerrorCode;
    }

    public String getErrorCode() {
        if (this.errorCode == null) {
            Throwable cause = this.getCause();
            if (cause != null && cause instanceof EcpException) {
                this.errorCode = ((EcpException)cause).getErrorCode();
            } else if (cause != null && cause instanceof EcpRuntimeException) {
                this.errorCode = ((EcpRuntimeException)cause).getErrorCode();
            }
        }
        return this.errorCode;
    }

    public String getMessage() {
        return super.getMessage();
    }

    public String toString() {
        String s = this.getClass().getName();
        String message = this.getLocalizedMessage();
        return message != null ? message : s;
    }
}

