/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.entity;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.config.DatabaseType;
import com.ygsoft.ecp.service.exception.NotSupportException;
import com.ygsoft.ecp.service.tool.DBUitl;
import java.sql.Timestamp;

public final class DBSysdate {
    private static final String GET_ORA_SYSDATE = "SELECT SYSDATE FROM DUAL";
    private static final String GET_H2_SYSDATE = "SELECT GETDATE()";
    private static final String GET_MYSQL_SYSDATE = "SELECT NOW()";
    private static final String GET_DB2_SYSDATE = "SELECT CURRENT TIMESTAMP FROM SYSIBM.SYSDUMMY1";

    private DBSysdate() {
    }

    public static Timestamp getDatabaseDate() {
        DatabaseType type = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (type == null) {
            return DBUitl.getDatabaseDate(GET_H2_SYSDATE);
        }
        return DBSysdate.getDatabaseDate(type);
    }

    public static Timestamp getDatabaseDate(DatabaseType dbType) {
        if (DatabaseType.Oracle.equals((Object)dbType) || DatabaseType.DM.equals((Object)dbType)) {
            return DBUitl.getDatabaseDate(GET_ORA_SYSDATE);
        }
        if (DatabaseType.H2.equals((Object)dbType) || DatabaseType.MSSQL.equals((Object)dbType)) {
            return DBUitl.getDatabaseDate(GET_H2_SYSDATE);
        }
        if (DatabaseType.MySql.equals((Object)dbType) || DatabaseType.KingBase.equals((Object)dbType) || DatabaseType.GBase.equals((Object)dbType)) {
            return DBUitl.getDatabaseDate(GET_MYSQL_SYSDATE);
        }
        if (DatabaseType.DB2.equals((Object)dbType) || DatabaseType.Derby.equals((Object)dbType)) {
            return DBUitl.getDatabaseDate(GET_DB2_SYSDATE);
        }
        throw new NotSupportException();
    }
}

