/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.dataaccess;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.ygsoft.ecp.framework.spring.SpringContextHolder;
import com.ygsoft.ecp.framework.util.ResourceUtil;
import com.ygsoft.ecp.service.data.model.SequenceInfo;
import com.ygsoft.ecp.service.exception.EcpDaoException;
import com.ygsoft.ecp.service.tool.DBUitl;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceGenerator
implements IEcpToolLogic {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceGenerator.class);
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    private static final Map<String, Long> currentValMap = new ConcurrentHashMap<String, Long>();
    private static final Map<String, Long> maxValMap = new ConcurrentHashMap<String, Long>();
    private static final String CAPTION_BZ = "\u5929\u64ce\u4ea7\u751f\u7684\u975e\u6807\u51c6\u952e\u503c\u7684\u81ea\u589e\u52a0\u503c\u8bb0\u5f55";
    private static final int defaultStep = 100;
    private static final String SEQUENCE_INFO_SELECT_ALL = "SELECT MAXID, IDENTNAME FROM XTMAXIID";
    private static final String SEQUENCE_INFO_SELECT = "SELECT MAXID FROM XTMAXIID WHERE IDENTNAME = ?";
    private static final String SEQUENCE_INFO_INSERT = "INSERT INTO XTMAXIID (BZ, MAXID, IDENTNAME, CACHESIZE, INITVALUE, FANIVALUE) VALUES (?,?,?,?,?,?)";
    private static final String SEQUENCE_INFO_UPDATE = "UPDATE XTMAXIID SET MAXID = ? WHERE IDENTNAME = ?";
    private static final String SEQUENCE_INFO_LOCK = "SELECT MAXID FROM XTMAXIID WHERE IDENTNAME = ? FOR UPDATE";
    private static final String SEQUENCE_INFO_LOCK_MQSQL = "SELECT MAXID FROM XTMAXIID UPDLOCK WHERE IDENTNAME = ? ";
    private static final String SEQUENCE_INIT_JSON = "classpath*:/META-INF/ecp-sequence/ecp.sequenceinit.json";
    private static DataSource DATA_SOURCE = null;
    private static ObjectMapper objectMapper = new ObjectMapper();

    private static String getSequenceInfoLockSql() {
        if (DBUitl.isMsSql()) {
            return SEQUENCE_INFO_LOCK_MQSQL;
        }
        return SEQUENCE_INFO_LOCK;
    }

    public static long getSequence(String sid) {
        return SequenceGenerator.getSequence(sid, 100);
    }

    public static long getSequence(final String sid, final int step) {
        Callable<Long> c = new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                Long maxVal;
                Long currentVal = (Long)currentValMap.get(sid);
                if (currentVal == null) {
                    currentVal = 0L;
                }
                if ((maxVal = (Long)maxValMap.get(sid)) == null) {
                    maxVal = 0L;
                }
                long offset = maxVal - currentVal;
                if (currentVal >= maxVal || offset >= (long)step) {
                    SequenceGenerator.fetchFromDB(sid, step);
                    currentVal = (Long)maxValMap.get(sid) - (long)step;
                }
                Long l = currentVal;
                Long l2 = currentVal = Long.valueOf(currentVal + 1L);
                currentValMap.put(sid, currentVal);
                return currentVal;
            }
        };
        Future<Long> task = EXECUTOR.submit(c);
        try {
            return task.get();
        }
        catch (Exception e) {
            throw new EcpDaoException("SequenceGenerator", e);
        }
    }

    protected static void initConfigData() {
        block7: {
            try {
                List urls = ResourceUtil.findResources((String)SEQUENCE_INIT_JSON);
                for (URL url : urls) {
                    InputStream in = url.openStream();
                    if (LOG.isInfoEnabled()) {
                        LOG.info("\u8bfb\u53d6\u5e8f\u5217\u53f7\u521d\u59cb\u5316\u6587\u4ef6\u3010" + url.toString() + "\u3011");
                    }
                    JavaType type = TypeFactory.defaultInstance().constructParametricType(List.class, new Class[]{SequenceInfo.class});
                    List sqInfos = (List)objectMapper.readValue(in, type);
                    for (SequenceInfo seqInfo : sqInfos) {
                        String sid = seqInfo.getSid();
                        if (StringUtil.isEmpty(sid) && LOG.isErrorEnabled()) {
                            LOG.error("\u5e8f\u5217\u53f7\u521d\u59cb\u5316\u53c2\u6570sid\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5f53\u524d\u6570\u636e\u521d\u59cb\u5316");
                            continue;
                        }
                        long id = seqInfo.getId();
                        if (id == 0L && LOG.isErrorEnabled()) {
                            LOG.error("\u5e8f\u5217\u53f7\u521d\u59cb\u5316\u53c2\u6570id\u4e3a\u7a7a\u62160\uff0c\u8df3\u8fc7\u5f53\u524d\u6570\u636esid\u4e3a" + sid + "\u521d\u59cb\u5316");
                            continue;
                        }
                        SequenceGenerator.initData(seqInfo);
                    }
                }
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error("sequence init error.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void initData(SequenceInfo seqInfo) {
        block30: {
            SQLException e222222;
            ResultSet rs;
            PreparedStatement st;
            Connection conn;
            block26: {
                DataSource ds = SequenceGenerator.getDataSource();
                conn = null;
                st = null;
                rs = null;
                String sid = seqInfo.getSid();
                conn = ds.getConnection();
                conn.setAutoCommit(false);
                st = conn.prepareStatement(SequenceGenerator.getSequenceInfoLockSql());
                st.setString(1, sid);
                rs = st.executeQuery();
                if (!rs.next()) {
                    st = conn.prepareStatement(SEQUENCE_INFO_INSERT);
                    st.setString(1, CAPTION_BZ);
                    st.setLong(2, seqInfo.getId());
                    st.setString(3, sid);
                    long step = seqInfo.getStep() > 0L ? seqInfo.getStep() : 100L;
                    st.setLong(4, step);
                    long min = seqInfo.getMin() > 0L ? seqInfo.getMin() : 1L;
                    st.setLong(5, min);
                    long max = seqInfo.getMax() > 0L ? seqInfo.getMax() : Integer.MAX_VALUE;
                    st.setLong(6, max);
                    st.executeUpdate();
                }
                rs.close();
                conn.commit();
                conn.setAutoCommit(true);
                Object var13_10 = null;
                if (rs == null) break block26;
                try {
                    rs.close();
                }
                catch (SQLException e222222) {
                    e222222.printStackTrace();
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e222222) {
                    e222222.printStackTrace();
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e222222) {
                    e222222.printStackTrace();
                }
            }
            break block30;
            {
                catch (Exception e3) {
                    SQLException e222222;
                    if (LOG.isErrorEnabled()) {
                        LOG.error("sequence sql init error.", (Throwable)e3);
                    }
                    Object var13_11 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e222222) {
                            e222222.printStackTrace();
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e222222) {
                            e222222.printStackTrace();
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e222222) {
                            e222222.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException e222222;
                Object var13_12 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e222222) {
                        e222222.printStackTrace();
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e222222) {
                        e222222.printStackTrace();
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e222222) {
                        e222222.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void fetchFromDB(String sid, int step) {
        ds = SequenceGenerator.getDataSource();
        conn = null;
        st = null;
        rs = null;
        try {
            block40: {
                conn = ds.getConnection();
                if (conn.getAutoCommit()) {
                    conn.setAutoCommit(false);
                }
                currentId = 0L;
                if (sid != null) break block40;
                st = conn.prepareStatement("SELECT MAXID, IDENTNAME FROM XTMAXIID");
                rs = st.executeQuery();
                while (rs.next()) {
                    id = rs.getLong(1);
                    s = rs.getString(2);
                    if (s == null || s.trim().length() <= 0) continue;
                    SequenceGenerator.currentValMap.put(s, id);
                }
                var11_12 = null;
                if (rs == null) ** GOTO lbl121
                ** GOTO lbl116
            }
            st = conn.prepareStatement("SELECT MAXID FROM XTMAXIID WHERE IDENTNAME = ?");
            st.setString(1, sid);
            rs = st.executeQuery();
            while (rs.next()) {
                currentId = rs.getLong(1);
            }
            rs.close();
            st.close();
            st = conn.prepareStatement(SequenceGenerator.getSequenceInfoLockSql());
            st.setString(1, sid);
            rs = st.executeQuery();
            flag = rs.next();
            if (!flag) {
                st = conn.prepareStatement("INSERT INTO XTMAXIID (BZ, MAXID, IDENTNAME, CACHESIZE, INITVALUE, FANIVALUE) VALUES (?,?,?,?,?,?)");
                st.setString(1, "\u5929\u64ce\u4ea7\u751f\u7684\u975e\u6807\u51c6\u952e\u503c\u7684\u81ea\u589e\u52a0\u503c\u8bb0\u5f55");
                st.setLong(2, 0L);
                st.setString(3, sid);
                st.setLong(4, 100L);
                st.setLong(5, 1L);
                st.setLong(6, 0x7FFFFFFFL);
                st.executeUpdate();
            }
            if (flag) {
                currentVal = rs.getLong(1) + 1L;
                SequenceGenerator.currentValMap.put(sid, currentVal);
            }
            rs.close();
            st = conn.prepareStatement("UPDATE XTMAXIID SET MAXID = ? WHERE IDENTNAME = ?");
            st.setLong(1, currentId + (long)step);
            st.setString(2, sid);
            st.executeUpdate();
            st = conn.prepareStatement(SequenceGenerator.getSequenceInfoLockSql());
            st.setString(1, sid);
            rs = st.executeQuery();
            if (rs.next()) {
                maxVal = rs.getLong(1);
                SequenceGenerator.maxValMap.put(sid, maxVal);
            }
            conn.commit();
            conn.setAutoCommit(true);
            ** GOTO lbl136
        }
        catch (Exception e) {
            e.printStackTrace();
            var11_14 = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (conn == null) return;
            try {
                conn.close();
                return;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return;
            }
        }
        {
            block39: {
                block38: {
                    block37: {
                        block41: {
                            catch (Throwable var10_20) {
                                block36: {
                                    block35: {
                                        var11_15 = null;
                                        if (rs != null) {
                                            ** try [egrp 2[TRYBLOCK] [6 : 512->522)] { 
lbl97:
                                            // 1 sources

                                            rs.close();
                                            break block35;
lbl99:
                                            // 1 sources

                                            catch (SQLException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                    if (st != null) {
                                        ** try [egrp 3[TRYBLOCK] [7 : 534->544)] { 
lbl104:
                                        // 1 sources

                                        st.close();
                                        break block36;
lbl106:
                                        // 1 sources

                                        catch (SQLException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                                if (conn == null) throw var10_20;
                                ** try [egrp 4[TRYBLOCK] [8 : 555->564)] { 
lbl111:
                                // 1 sources

                                conn.close();
                                throw var10_20;
lbl113:
                                // 1 sources

                                catch (SQLException e) {
                                    e.printStackTrace();
                                }
                                throw var10_20;
                            }
lbl116:
                            // 1 sources

                            ** try [egrp 2[TRYBLOCK] [6 : 512->522)] { 
lbl117:
                            // 1 sources

                            rs.close();
                            break block41;
lbl119:
                            // 1 sources

                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                        if (st != null) {
                            ** try [egrp 3[TRYBLOCK] [7 : 534->544)] { 
lbl124:
                            // 1 sources

                            st.close();
                            break block37;
lbl126:
                            // 1 sources

                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (conn == null) return;
                    ** try [egrp 4[TRYBLOCK] [8 : 555->564)] { 
lbl131:
                    // 1 sources

                    conn.close();
                    return;
lbl133:
                    // 1 sources

                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    return;
lbl136:
                    // 1 sources

                    var11_13 = null;
                    if (rs != null) {
                        ** try [egrp 2[TRYBLOCK] [6 : 512->522)] { 
lbl139:
                        // 1 sources

                        rs.close();
                        break block38;
lbl141:
                        // 1 sources

                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (st != null) {
                    ** try [egrp 3[TRYBLOCK] [7 : 534->544)] { 
lbl146:
                    // 1 sources

                    st.close();
                    break block39;
lbl148:
                    // 1 sources

                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (conn == null) return;
            try {}
            catch (SQLException e) {}
            e.printStackTrace();
            return;
            conn.close();
            return;
        }
    }

    private static DataSource getDataSource() {
        if (DATA_SOURCE == null) {
            DATA_SOURCE = (DataSource)SpringContextHolder.INSTANCE.getApplicationContext().getBean("dataSource");
        }
        return DATA_SOURCE;
    }

    static {
        try {
            SequenceGenerator.initConfigData();
            SequenceGenerator.fetchFromDB(null, 100);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

