/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service;

import com.ygsoft.ecp.service.cache.ICache;
import com.ygsoft.ecp.service.cache.ICacheFactory;
import com.ygsoft.ecp.service.cache.IQueryCache;
import com.ygsoft.ecp.service.config.IConfigService;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.i18n.I18nResourceService;
import com.ygsoft.ecp.service.internal.config.ConfigService;
import com.ygsoft.ecp.service.internal.i18n.I18nResourceServiceImpl;
import com.ygsoft.ecp.service.internal.storage.StorageService;
import com.ygsoft.ecp.service.storage.IStorageService;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.zk.IZooKeeperClientFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EcpService {
    private EcpService() {
    }

    public static <K, V> ICache<K, V> getCacheService(String classID, String typeID) {
        return EcpService.getCacheService(StringUtil.genCacheName(classID, typeID));
    }

    public static <K, V> ICache<K, V> getThreadCache() {
        return EcpService.getCacheService("ThreadCache");
    }

    public static <K, V> ICache<K, V> getTimeExpireCache() {
        return EcpService.getCacheService("TimeExpireCache");
    }

    public static <K, V> ICache<K, V> getCacheService(String cacheTopic) {
        return EcpService.getCacheFactory().getCache(cacheTopic);
    }

    public static <K, V> ICache<K, V> getLRUCache(String cacheTopic) {
        return EcpService.getCacheFactory().getLRUCache(cacheTopic);
    }

    public static <V> IQueryCache<V> getQueryCacheService(String classID, String typeID) {
        return EcpService.getQueryCacheService(StringUtil.genCacheName(classID, typeID));
    }

    public static <V> IQueryCache<V> getQueryCacheService(String cacheTopic) {
        return EcpService.getCacheFactory().getQueryCache(cacheTopic);
    }

    public static I18nResourceService getI18nResourceService() {
        return new I18nResourceServiceImpl(null, null);
    }

    public static IConfigService getConfigService() {
        return ConfigService.INSTANCE;
    }

    public static ICacheFactory getCacheFactory() {
        try {
            String clsName = "com.ygsoft.ecp.service.cache.impl.factory.CacheFactoryImpl";
            return (ICacheFactory)Class.forName("com.ygsoft.ecp.service.cache.impl.factory.CacheFactoryImpl").newInstance();
        }
        catch (Exception e) {
            throw new EcpRuntimeException("service.CacheFacory_NOT_FOUND", EcpI18nUtil.localizedString("service.CacheFacory_NOT_FOUND", "\u7f13\u5b58\u5de5\u5382\u7c7b\u6ca1\u6709\u627e\u5230"), e, new Object[0]);
        }
    }

    public static IZooKeeperClientFactory getZooKeeperClientFactory() {
        IZooKeeperClientFactory zkClientFactory;
        try {
            zkClientFactory = OSGiUtil.getService(IZooKeeperClientFactory.class);
        }
        catch (Throwable e) {
            zkClientFactory = null;
        }
        if (zkClientFactory == null) {
            try {
                String clsName = "com.ygsoft.ecp.zookeeper.service.ZooKeeperClientFactory";
                zkClientFactory = (IZooKeeperClientFactory)Class.forName("com.ygsoft.ecp.zookeeper.service.ZooKeeperClientFactory").newInstance();
            }
            catch (Exception e) {
                throw new EcpRuntimeException("service.ZooKeeperClientFactory_NOT_FOUND", EcpI18nUtil.localizedString("service.ZooKeeperClientFactory_NOT_FOUND", "zookeeper\u5de5\u5382\u7c7b\u6ca1\u6709\u627e\u5230"), e, new Object[0]);
            }
        }
        return zkClientFactory;
    }

    public static IStorageService getStorageService() {
        return StorageService.INSTANCE;
    }
}

