/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.code.arthas;

import com.ygsoft.ecp.framework.code.arthas.Matcher;
import com.ygsoft.ecp.framework.code.arthas.RegexMatcher;
import com.ygsoft.ecp.framework.code.arthas.WildcardMatcher;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchUtils {
    public static Set<Class<?>> searchClass(Instrumentation inst, Matcher<String> classNameMatcher, int limit) {
        if (classNameMatcher == null) {
            return Collections.emptySet();
        }
        HashSet matches = new HashSet();
        for (Class clazz : inst.getAllLoadedClasses()) {
            if (clazz == null) continue;
            if (classNameMatcher.matching(clazz.getName())) {
                matches.add(clazz);
            }
            if (matches.size() >= limit) break;
        }
        return matches;
    }

    public static Set<Class<?>> searchClass(Instrumentation inst, Matcher<String> classNameMatcher) {
        return SearchUtils.searchClass(inst, classNameMatcher, Integer.MAX_VALUE);
    }

    public static Set<Class<?>> searchClass(Instrumentation inst, String classPattern, boolean isRegEx) {
        Matcher<String> classNameMatcher = SearchUtils.classNameMatcher(classPattern, isRegEx);
        return SearchUtils.searchSubClass(inst, SearchUtils.searchClass(inst, classNameMatcher));
    }

    public static Set<Class<?>> searchClass(Instrumentation inst, String classPattern, boolean isRegEx, String code) {
        Set<Class<?>> matchedClasses = SearchUtils.searchClass(inst, classPattern, isRegEx);
        return SearchUtils.filter(matchedClasses, code);
    }

    public static Set<Class<?>> searchClassOnly(Instrumentation inst, String classPattern, boolean isRegEx) {
        Matcher<String> classNameMatcher = SearchUtils.classNameMatcher(classPattern, isRegEx);
        return SearchUtils.searchClass(inst, classNameMatcher);
    }

    public static Set<Class<?>> searchClassOnly(Instrumentation inst, String classPattern, int limit) {
        Matcher<String> classNameMatcher = SearchUtils.classNameMatcher(classPattern, false);
        return SearchUtils.searchClass(inst, classNameMatcher, limit);
    }

    public static Set<Class<?>> searchClassOnly(Instrumentation inst, String classPattern, boolean isRegEx, String code) {
        Set<Class<?>> matchedClasses = SearchUtils.searchClassOnly(inst, classPattern, isRegEx);
        return SearchUtils.filter(matchedClasses, code);
    }

    private static Set<Class<?>> filter(Set<Class<?>> matchedClasses, String code) {
        if (code == null) {
            return matchedClasses;
        }
        HashSet result = new HashSet();
        if (matchedClasses != null) {
            for (Class<?> c : matchedClasses) {
                if (c.getClassLoader() == null || !Integer.toHexString(c.getClassLoader().hashCode()).equals(code)) continue;
                result.add(c);
            }
        }
        return result;
    }

    public static Matcher<String> classNameMatcher(String classPattern, boolean isRegEx) {
        if (classPattern == null || "".equals(classPattern)) {
            String string = classPattern = isRegEx ? ".*" : "*";
        }
        if (!classPattern.contains("$$Lambda")) {
            classPattern = SearchUtils.replace(classPattern, "/", ".");
        }
        return isRegEx ? new RegexMatcher(classPattern) : new WildcardMatcher(classPattern);
    }

    public static Set<Class<?>> searchSubClass(Instrumentation inst, Set<Class<?>> classSet) {
        HashSet matches = new HashSet();
        block0: for (Class clazz : inst.getAllLoadedClasses()) {
            if (clazz == null) continue;
            for (Class<?> superClass : classSet) {
                if (!superClass.isAssignableFrom(clazz)) continue;
                matches.add(clazz);
                continue block0;
            }
        }
        return matches;
    }

    public static Set<Class<?>> searchInnerClass(Instrumentation inst, Class<?> c) {
        HashSet matches = new HashSet();
        for (Class clazz : inst.getInitiatedClasses(c.getClassLoader())) {
            if (c.getClassLoader() == null || clazz.getClassLoader() == null || !c.getClassLoader().equals(clazz.getClassLoader()) || !clazz.getName().startsWith(c.getName())) continue;
            matches.add(clazz);
        }
        return matches;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (SearchUtils.hasLength(inString) && SearchUtils.hasLength(oldPattern) && newPattern != null) {
            int pos = 0;
            int index = inString.indexOf(oldPattern);
            if (index < 0) {
                return inString;
            }
            StringBuilder sb = new StringBuilder();
            int patLen = oldPattern.length();
            while (index >= 0) {
                sb.append(inString, pos, index);
                sb.append(newPattern);
                pos = index + patLen;
                index = inString.indexOf(oldPattern, pos);
            }
            sb.append(inString.substring(pos));
            return sb.toString();
        }
        return inString;
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }
}

