/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.async.util;

import com.ygsoft.ecp.framework.cons.ServerProps;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtExecutorsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtExecutorsService.class);
    private static volatile ExecutorService INSTANCE = null;
    public static final String NUM_THREADS_CONFIG = "necp.executors.number-threads";
    public static final String BE_ASYNC_CONFIG = "necp.executors.be-async";
    private static int numThreads = Integer.parseInt(System.getProperty("necp.executors.number-threads", "10"));
    private static boolean beAsync = Boolean.valueOf(System.getProperty("necp.executors.be-async", "true"));
    private static List<String> noSpeedupClasses = Arrays.asList(ServerProps.getProperty("necp.speedup.exclude-classes", "").split(","));

    private ExtExecutorsService() {
    }

    public static boolean beAsync() {
        return beAsync;
    }

    public static boolean beAsync(Object obj) {
        return beAsync && !ExtExecutorsService.noSpeedup(obj);
    }

    private static boolean noSpeedup(Object obj) {
        String clazzName = obj.getClass().getTypeName();
        return noSpeedupClasses.contains(clazzName);
    }

    public static ExecutorService INSTANCE() {
        return ExtExecutorsService.genINSTANCE(null);
    }

    public static ExecutorService INSTANCE(Integer numThreads) {
        return ExtExecutorsService.genINSTANCE(numThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ExecutorService genINSTANCE(Integer numThreads) {
        if (null != INSTANCE) return INSTANCE;
        Class<ExtExecutorsService> clazz = ExtExecutorsService.class;
        synchronized (ExtExecutorsService.class) {
            if (null != INSTANCE) return INSTANCE;
            ExtExecutorsService.init(numThreads);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static void init(Integer numThreads) {
        INSTANCE = Executors.newFixedThreadPool(null == numThreads ? ExtExecutorsService.numThreads : numThreads, new DefaultThreadFactory());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Executors newFixedThreadPool {} thread ", (Object)ExtExecutorsService.numThreads);
        }
    }

    public static void destroy() {
        if (null != INSTANCE) {
            INSTANCE.shutdown();
            INSTANCE = null;
        }
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "Async-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

