/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.actuator;

import com.ygsoft.ecp.framework.cons.MappConst;
import com.ygsoft.ecp.framework.cons.ServerProps;
import com.ygsoft.ecp.framework.util.IPUtil;
import java.net.URLDecoder;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public final class TraceHolder {
    private final ThreadLocal<String> ID = new ThreadLocal();
    private final ThreadLocal<String> TID = new ThreadLocal();
    private final ThreadLocal<String> PID = new ThreadLocal();
    private final ThreadLocal<String> USERNAME = new ThreadLocal();
    private final ThreadLocal<String> MAPP_VIP = new ThreadLocal();
    private final ThreadLocal<String> MAPP_IP = new ThreadLocal();
    private final ThreadLocal<String> MAPP_PORT = new ThreadLocal();
    public static final TraceHolder INSTANCE = new TraceHolder();
    public static final String VIP_DEBUG_KEY = "develop.vipaddress";
    private static boolean isVipDebug = System.getProperty("develop.vipaddress") != null && System.getProperty("develop.vipaddress").indexOf("@") > 0;
    private final ThreadLocal<String> ERROR_CODE = new ThreadLocal();
    private final ThreadLocal<String> TRACE_LOGED = new ThreadLocal();
    public static final String TRACE_ID_KEY = "traceId";

    public void setLoged() {
        this.TRACE_LOGED.set("true");
    }

    public String getLoged() {
        return this.TRACE_LOGED.get();
    }

    public void clearLog() {
        this.TRACE_LOGED.remove();
    }

    private TraceHolder() {
    }

    public String getId() {
        String id = this.ID.get();
        if (id != null && id.trim().length() > 0) {
            return id;
        }
        id = UUID.randomUUID().toString();
        this.setId(id);
        return id;
    }

    public void setId(String id) {
        this.ID.set(id);
    }

    public String getTid() {
        String tid = this.TID.get();
        if (tid != null && tid.trim().length() > 0) {
            return tid;
        }
        tid = UUID.randomUUID().toString();
        this.setTid(tid);
        return tid;
    }

    public void setTid(String tid) {
        this.TID.set(tid);
        if (tid != null) {
            String strTid = String.valueOf(tid.hashCode());
            MDC.put((String)TRACE_ID_KEY, (String)strTid.replaceAll("-", ""));
        }
    }

    public String getPid() {
        return this.PID.get();
    }

    private void setPid(String pid) {
        this.PID.set(pid);
    }

    public String getErrorCode() {
        return this.ERROR_CODE.get();
    }

    public void setErrorCode(String errorCode) {
        this.ERROR_CODE.set(errorCode);
    }

    public String getUsername() {
        return this.USERNAME.get();
    }

    public String getMappVIP() {
        return this.MAPP_VIP.get();
    }

    public String getMappIP() {
        return this.MAPP_IP.get();
    }

    public String getMappPort() {
        return this.MAPP_PORT.get();
    }

    public void setPid(HttpServletRequest httpRequest) {
        String tid = httpRequest.getHeader("trice_tid");
        if (tid == null || tid.trim().length() == 0) {
            tid = httpRequest.getParameter("trice_tid");
        }
        if (tid != null && tid.trim().length() > 0) {
            this.setTid(tid);
        } else {
            this.setTid("");
        }
        String pid = httpRequest.getHeader("trice_pid");
        if (pid == null || pid.trim().length() == 0) {
            pid = httpRequest.getParameter("trice_pid");
        }
        if (pid != null && pid.trim().length() > 0) {
            this.setPid(pid);
        } else {
            this.setPid("");
        }
        this.setUserName(httpRequest);
        String mappVip = httpRequest.getHeader("mappVip");
        if (mappVip == null || mappVip.trim().length() == 0) {
            mappVip = httpRequest.getParameter("mappVip");
        }
        if (mappVip != null && mappVip.trim().length() > 0) {
            this.MAPP_VIP.set(mappVip);
        } else if (MappConst.isDevelopMode()) {
            if (isVipDebug) {
                this.MAPP_VIP.set(ServerProps.getProperty(VIP_DEBUG_KEY));
            } else {
                this.MAPP_VIP.set(ServerProps.getProperty("server.vipaddress"));
            }
        } else {
            this.MAPP_VIP.set("");
        }
        String mappIp = httpRequest.getHeader("mappIp");
        if (mappIp == null || mappIp.trim().length() == 0) {
            mappIp = httpRequest.getParameter("mappIp");
        }
        if (mappIp != null && mappIp.trim().length() > 0) {
            this.MAPP_IP.set(mappIp);
        } else if (MappConst.isDevelopMode()) {
            if (isVipDebug) {
                this.MAPP_IP.set("*");
            } else {
                String ip = IPUtil.getHostIP();
                if (ip == null) {
                    ip = "";
                }
                this.MAPP_IP.set(ip);
            }
        } else {
            this.MAPP_IP.set("");
        }
        String mappPort = httpRequest.getHeader("mappPort");
        if (mappPort == null || mappPort.trim().length() == 0) {
            mappPort = httpRequest.getParameter("mappPort");
        }
        if (mappPort != null && mappPort.trim().length() > 0) {
            this.MAPP_PORT.set(mappPort);
        } else if (MappConst.isDevelopMode()) {
            if (isVipDebug) {
                this.MAPP_PORT.set("*");
            } else {
                this.MAPP_PORT.set(String.valueOf(MappConst.getServerPort()));
            }
        } else {
            this.MAPP_PORT.set("");
        }
    }

    private void setUserName(HttpServletRequest httpRequest) {
        try {
            String username = httpRequest.getHeader("trice_userName");
            if (username == null || username.trim().length() == 0) {
                username = httpRequest.getParameter("trice_userName");
            }
            if (username != null && username.trim().length() > 0) {
                this.USERNAME.set(username);
            } else {
                this.USERNAME.set("");
            }
        }
        catch (Throwable e) {
            this.USERNAME.set("");
        }
    }

    public String getSourceVip(HttpServletRequest httpRequest) {
        String value = httpRequest.getHeader("trice_sourceVip");
        if (value == null || value.trim().length() == 0) {
            value = httpRequest.getParameter("trice_sourceVip");
        }
        try {
            if (value != null) {
                return URLDecoder.decode(value, "UTF-8");
            }
            if ("true".equals(httpRequest.getHeader("mapp.standAlone"))) {
                value = httpRequest.getHeader("x-forwarded-mapp");
            }
            value = System.getProperty("server.vipaddress");
        }
        finally {
            return value;
        }
    }

    public String getSourceIp(HttpServletRequest httpRequest) {
        String value = httpRequest.getHeader("trice_sourceIp");
        if (value == null || value.trim().length() == 0) {
            value = httpRequest.getParameter("trice_sourceIp");
        }
        if (value == null) {
            value = "true".equals(httpRequest.getHeader("mapp.standAlone")) ? httpRequest.getHeader("x-forwarded-for") : IPUtil.getHostIP();
        }
        return value;
    }

    public int getSourcePort(HttpServletRequest httpRequest) {
        String value = httpRequest.getHeader("trice_soucePort");
        if (value == null || value.trim().length() == 0) {
            value = httpRequest.getParameter("trice_soucePort");
        }
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                return 9080;
            }
        }
        if ("true".equals(httpRequest.getHeader("mapp.standAlone"))) {
            value = httpRequest.getHeader("via");
            if (value != null && value.lastIndexOf("-") != -1) {
                value = value.substring(value.lastIndexOf("-") + 1);
                return Integer.parseInt(value);
            }
            return MappConst.getServerPort();
        }
        return MappConst.getServerPort();
    }

    public String getRegisterUrl(HttpServletRequest httpRequest) {
        String value = httpRequest.getHeader("trice_registerUrl");
        if (value == null || value.trim().length() == 0) {
            value = httpRequest.getParameter("trice_registerUrl");
        }
        try {
            if (value != null) {
                value = URLDecoder.decode(value, "UTF-8");
            }
            value = System.getProperty("mapp.serviceRegisterUrl");
        }
        finally {
            return value;
        }
    }

    public void clearId() {
        this.ID.remove();
    }

    public void clearPid() {
        this.TID.remove();
        MDC.remove((String)TRACE_ID_KEY);
        this.PID.remove();
        this.USERNAME.remove();
        this.MAPP_VIP.remove();
        this.MAPP_IP.remove();
        this.MAPP_PORT.remove();
    }

    public String toString() {
        return "TraceHolder [ID=" + this.ID.get() + ", TID=" + this.TID.get() + ", PID=" + this.PID.get() + ", USERNAME=" + this.USERNAME.get() + ", MAPP_VIP=" + this.MAPP_VIP.get() + ", MAPP_IP=" + this.MAPP_IP.get() + ", MAPP_PORT=" + this.MAPP_PORT.get() + "]";
    }
}

