/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.operator.jcajce;

import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.bouncycastle162.asn1.cms.GenericHybridParameters;
import org.bouncycastle162.asn1.cms.RsaKemParameters;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.crypto.util.DEROtherInfo;
import org.bouncycastle162.jcajce.spec.KTSParameterSpec;
import org.bouncycastle162.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle162.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle162.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle162.operator.AsymmetricKeyUnwrapper;
import org.bouncycastle162.operator.GenericKey;
import org.bouncycastle162.operator.OperatorException;
import org.bouncycastle162.operator.jcajce.JceGenericKey;
import org.bouncycastle162.operator.jcajce.OperatorHelper;
import org.bouncycastle162.util.Arrays;

public class JceKTSKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private Map extraMappings = new HashMap();
    private PrivateKey privKey;
    private byte[] partyUInfo;
    private byte[] partyVInfo;

    public JceKTSKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privKey, byte[] partyUInfo, byte[] partyVInfo) {
        super(algorithmIdentifier);
        this.privKey = privKey;
        this.partyUInfo = Arrays.clone(partyUInfo);
        this.partyVInfo = Arrays.clone(partyVInfo);
    }

    public JceKTSKeyUnwrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKTSKeyUnwrapper setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        Key sKey;
        GenericHybridParameters params = GenericHybridParameters.getInstance(this.getAlgorithmIdentifier().getParameters());
        Cipher keyCipher = this.helper.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm(), this.extraMappings);
        String symmetricWrappingAlg = this.helper.getWrappingAlgorithmName(params.getDem().getAlgorithm());
        RsaKemParameters kemParameters = RsaKemParameters.getInstance(params.getKem().getParameters());
        int keySizeInBits = kemParameters.getKeyLength().intValue() * 8;
        try {
            DEROtherInfo otherInfo = new DEROtherInfo.Builder(params.getDem(), this.partyUInfo, this.partyVInfo).build();
            KTSParameterSpec ktsSpec = new KTSParameterSpec.Builder(symmetricWrappingAlg, keySizeInBits, otherInfo.getEncoded()).withKdfAlgorithm(kemParameters.getKeyDerivationFunction()).build();
            keyCipher.init(4, (Key)this.privKey, ktsSpec);
            sKey = keyCipher.unwrap(encryptedKey, this.helper.getKeyAlgorithmName(encryptedKeyAlgorithm.getAlgorithm()), 3);
        }
        catch (Exception e) {
            throw new OperatorException("Unable to unwrap contents key: " + e.getMessage(), e);
        }
        return new JceGenericKey(encryptedKeyAlgorithm, sKey);
    }
}

