/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.jce.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle162.asn1.DERNull;
import org.bouncycastle162.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle162.asn1.pkcs.RSAPublicKey;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle162.crypto.params.RSAKeyParameters;
import org.bouncycastle162.jcajce.provider.asymmetric.util.KeyUtil;
import org.bouncycastle162.util.Strings;

public class JCERSAPublicKey
implements java.security.interfaces.RSAPublicKey {
    static final long serialVersionUID = 2675817738516720772L;
    private BigInteger modulus;
    private BigInteger publicExponent;

    JCERSAPublicKey(RSAKeyParameters key) {
        this.modulus = key.getModulus();
        this.publicExponent = key.getExponent();
    }

    JCERSAPublicKey(RSAPublicKeySpec spec) {
        this.modulus = spec.getModulus();
        this.publicExponent = spec.getPublicExponent();
    }

    JCERSAPublicKey(java.security.interfaces.RSAPublicKey key) {
        this.modulus = key.getModulus();
        this.publicExponent = key.getPublicExponent();
    }

    JCERSAPublicKey(SubjectPublicKeyInfo info) {
        try {
            RSAPublicKey pubKey = RSAPublicKey.getInstance(info.parsePublicKey());
            this.modulus = pubKey.getModulus();
            this.publicExponent = pubKey.getPublicExponent();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid info structure in RSA public key");
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPublicKey(this.getModulus(), this.getPublicExponent()));
    }

    public int hashCode() {
        return this.getModulus().hashCode() ^ this.getPublicExponent().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof java.security.interfaces.RSAPublicKey)) {
            return false;
        }
        java.security.interfaces.RSAPublicKey key = (java.security.interfaces.RSAPublicKey)o;
        return this.getModulus().equals(key.getModulus()) && this.getPublicExponent().equals(key.getPublicExponent());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = Strings.lineSeparator();
        buf.append("RSA Public Key").append(nl);
        buf.append("            modulus: ").append(this.getModulus().toString(16)).append(nl);
        buf.append("    public exponent: ").append(this.getPublicExponent().toString(16)).append(nl);
        return buf.toString();
    }
}

