/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cms;

import org.bouncycastle162.asn1.DEROctetString;
import org.bouncycastle162.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle162.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle162.asn1.cms.RecipientIdentifier;
import org.bouncycastle162.asn1.cms.RecipientInfo;
import org.bouncycastle162.cms.CMSException;
import org.bouncycastle162.cms.RecipientInfoGenerator;
import org.bouncycastle162.operator.AsymmetricKeyWrapper;
import org.bouncycastle162.operator.GenericKey;
import org.bouncycastle162.operator.OperatorException;

public abstract class KeyTransRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final AsymmetricKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KeyTransRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerial, AsymmetricKeyWrapper wrapper) {
        this.issuerAndSerial = issuerAndSerial;
        this.wrapper = wrapper;
    }

    protected KeyTransRecipientInfoGenerator(byte[] subjectKeyIdentifier, AsymmetricKeyWrapper wrapper) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.wrapper = wrapper;
    }

    public final RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        byte[] encryptedKeyBytes;
        try {
            encryptedKeyBytes = this.wrapper.generateWrappedKey(contentEncryptionKey);
        }
        catch (OperatorException e) {
            throw new CMSException("exception wrapping content key: " + e.getMessage(), e);
        }
        RecipientIdentifier recipId = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        return new RecipientInfo(new KeyTransRecipientInfo(recipId, this.wrapper.getAlgorithmIdentifier(), new DEROctetString(encryptedKeyBytes)));
    }
}

