/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle162.asn1.ASN1EncodableVector;
import org.bouncycastle162.asn1.BEROctetString;
import org.bouncycastle162.asn1.BERSet;
import org.bouncycastle162.asn1.DEROctetString;
import org.bouncycastle162.asn1.DERSet;
import org.bouncycastle162.asn1.cms.AuthenticatedData;
import org.bouncycastle162.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle162.asn1.cms.ContentInfo;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.cms.CMSAuthenticatedData;
import org.bouncycastle162.cms.CMSAuthenticatedGenerator;
import org.bouncycastle162.cms.CMSException;
import org.bouncycastle162.cms.CMSTypedData;
import org.bouncycastle162.cms.DefaultAuthenticatedAttributeTableGenerator;
import org.bouncycastle162.cms.RecipientInfoGenerator;
import org.bouncycastle162.operator.DigestCalculator;
import org.bouncycastle162.operator.DigestCalculatorProvider;
import org.bouncycastle162.operator.MacCalculator;
import org.bouncycastle162.operator.OperatorCreationException;
import org.bouncycastle162.util.io.TeeOutputStream;

public class CMSAuthenticatedDataGenerator
extends CMSAuthenticatedGenerator {
    public CMSAuthenticatedData generate(CMSTypedData typedData, MacCalculator macCalculator) throws CMSException {
        return this.generate(typedData, macCalculator, null);
    }

    public CMSAuthenticatedData generate(CMSTypedData typedData, MacCalculator macCalculator, final DigestCalculator digestCalculator) throws CMSException {
        AuthenticatedData authData;
        ByteArrayOutputStream bOut;
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        for (RecipientInfoGenerator recipient : this.recipientInfoGenerators) {
            recipientInfos.add(recipient.generate(macCalculator.getKey()));
        }
        if (digestCalculator != null) {
            DEROctetString macResult;
            BEROctetString encContent;
            try {
                bOut = new ByteArrayOutputStream();
                TeeOutputStream out = new TeeOutputStream(digestCalculator.getOutputStream(), bOut);
                typedData.write(out);
                ((OutputStream)out).close();
                encContent = new BEROctetString(bOut.toByteArray());
            }
            catch (IOException e) {
                throw new CMSException("unable to perform digest calculation: " + e.getMessage(), e);
            }
            Map parameters = this.getBaseParameters(typedData.getContentType(), digestCalculator.getAlgorithmIdentifier(), macCalculator.getAlgorithmIdentifier(), digestCalculator.getDigest());
            if (this.authGen == null) {
                this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
            }
            DERSet authed = new DERSet(this.authGen.getAttributes(Collections.unmodifiableMap(parameters)).toASN1EncodableVector());
            try {
                OutputStream mOut = macCalculator.getOutputStream();
                mOut.write(authed.getEncoded("DER"));
                mOut.close();
                macResult = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException e) {
                throw new CMSException("exception decoding algorithm parameters.", e);
            }
            BERSet unauthed = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(Collections.unmodifiableMap(parameters)).toASN1EncodableVector()) : null;
            ContentInfo eci = new ContentInfo(CMSObjectIdentifiers.data, encContent);
            authData = new AuthenticatedData(this.originatorInfo, new DERSet(recipientInfos), macCalculator.getAlgorithmIdentifier(), digestCalculator.getAlgorithmIdentifier(), eci, authed, macResult, unauthed);
        } else {
            DEROctetString macResult;
            BEROctetString encContent;
            try {
                bOut = new ByteArrayOutputStream();
                TeeOutputStream mOut = new TeeOutputStream(bOut, macCalculator.getOutputStream());
                typedData.write(mOut);
                ((OutputStream)mOut).close();
                encContent = new BEROctetString(bOut.toByteArray());
                macResult = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException e) {
                throw new CMSException("exception decoding algorithm parameters.", e);
            }
            BERSet unauthed = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(new HashMap()).toASN1EncodableVector()) : null;
            ContentInfo eci = new ContentInfo(CMSObjectIdentifiers.data, encContent);
            authData = new AuthenticatedData(this.originatorInfo, new DERSet(recipientInfos), macCalculator.getAlgorithmIdentifier(), null, eci, null, macResult, unauthed);
        }
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.authenticatedData, authData);
        return new CMSAuthenticatedData(contentInfo, new DigestCalculatorProvider(){

            public DigestCalculator get(AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
                return digestCalculator;
            }
        });
    }
}

