/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.tsp;

import java.util.Enumeration;
import org.bouncycastle162.asn1.ASN1Encodable;
import org.bouncycastle162.asn1.ASN1EncodableVector;
import org.bouncycastle162.asn1.ASN1Integer;
import org.bouncycastle162.asn1.ASN1Object;
import org.bouncycastle162.asn1.ASN1ObjectIdentifier;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.asn1.ASN1TaggedObject;
import org.bouncycastle162.asn1.DERSequence;
import org.bouncycastle162.asn1.tsp.ArchiveTimeStamp;
import org.bouncycastle162.asn1.tsp.ArchiveTimeStampChain;
import org.bouncycastle162.asn1.tsp.ArchiveTimeStampSequence;
import org.bouncycastle162.asn1.tsp.CryptoInfos;
import org.bouncycastle162.asn1.tsp.EncryptionInfo;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.util.BigIntegers;

public class EvidenceRecord
extends ASN1Object {
    private static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("1.3.6.1.5.5.11.0.2.1");
    private ASN1Integer version = new ASN1Integer(1L);
    private ASN1Sequence digestAlgorithms;
    private CryptoInfos cryptoInfos;
    private EncryptionInfo encryptionInfo;
    private ArchiveTimeStampSequence archiveTimeStampSequence;

    public static EvidenceRecord getInstance(Object obj) {
        if (obj instanceof EvidenceRecord) {
            return (EvidenceRecord)obj;
        }
        if (obj != null) {
            return new EvidenceRecord(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private EvidenceRecord(EvidenceRecord evidenceRecord, ArchiveTimeStampSequence replacementSequence, ArchiveTimeStamp newChainTimeStamp) {
        this.version = evidenceRecord.version;
        if (newChainTimeStamp != null) {
            AlgorithmIdentifier algId = newChainTimeStamp.getDigestAlgorithmIdentifier();
            ASN1EncodableVector vector = new ASN1EncodableVector();
            Enumeration enumeration = evidenceRecord.digestAlgorithms.getObjects();
            boolean found = false;
            while (enumeration.hasMoreElements()) {
                AlgorithmIdentifier algorithmIdentifier = AlgorithmIdentifier.getInstance(enumeration.nextElement());
                vector.add(algorithmIdentifier);
                if (!algorithmIdentifier.equals(algId)) continue;
                found = true;
                break;
            }
            if (!found) {
                vector.add(algId);
                this.digestAlgorithms = new DERSequence(vector);
            } else {
                this.digestAlgorithms = evidenceRecord.digestAlgorithms;
            }
        } else {
            this.digestAlgorithms = evidenceRecord.digestAlgorithms;
        }
        this.cryptoInfos = evidenceRecord.cryptoInfos;
        this.encryptionInfo = evidenceRecord.encryptionInfo;
        this.archiveTimeStampSequence = replacementSequence;
    }

    public EvidenceRecord(AlgorithmIdentifier[] digestAlgorithms, CryptoInfos cryptoInfos, EncryptionInfo encryptionInfo, ArchiveTimeStampSequence archiveTimeStampSequence) {
        this.digestAlgorithms = new DERSequence(digestAlgorithms);
        this.cryptoInfos = cryptoInfos;
        this.encryptionInfo = encryptionInfo;
        this.archiveTimeStampSequence = archiveTimeStampSequence;
    }

    private EvidenceRecord(ASN1Sequence sequence) {
        if (sequence.size() < 3 && sequence.size() > 5) {
            throw new IllegalArgumentException("wrong sequence size in constructor: " + sequence.size());
        }
        ASN1Integer versionNumber = ASN1Integer.getInstance(sequence.getObjectAt(0));
        if (!versionNumber.getValue().equals(BigIntegers.ONE)) {
            throw new IllegalArgumentException("incompatible version");
        }
        this.version = versionNumber;
        this.digestAlgorithms = ASN1Sequence.getInstance(sequence.getObjectAt(1));
        for (int i = 2; i != sequence.size() - 1; ++i) {
            ASN1Encodable object = sequence.getObjectAt(i);
            if (object instanceof ASN1TaggedObject) {
                ASN1TaggedObject asn1TaggedObject = (ASN1TaggedObject)object;
                switch (asn1TaggedObject.getTagNo()) {
                    case 0: {
                        this.cryptoInfos = CryptoInfos.getInstance(asn1TaggedObject, false);
                        break;
                    }
                    case 1: {
                        this.encryptionInfo = EncryptionInfo.getInstance(asn1TaggedObject, false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown tag in getInstance: " + asn1TaggedObject.getTagNo());
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
        }
        this.archiveTimeStampSequence = ArchiveTimeStampSequence.getInstance(sequence.getObjectAt(sequence.size() - 1));
    }

    public AlgorithmIdentifier[] getDigestAlgorithms() {
        AlgorithmIdentifier[] rv = new AlgorithmIdentifier[this.digestAlgorithms.size()];
        for (int i = 0; i != rv.length; ++i) {
            rv[i] = AlgorithmIdentifier.getInstance(this.digestAlgorithms.getObjectAt(i));
        }
        return rv;
    }

    public ArchiveTimeStampSequence getArchiveTimeStampSequence() {
        return this.archiveTimeStampSequence;
    }

    public EvidenceRecord addArchiveTimeStamp(ArchiveTimeStamp ats, boolean newChain) {
        if (newChain) {
            ArchiveTimeStampChain chain = new ArchiveTimeStampChain(ats);
            return new EvidenceRecord(this, this.archiveTimeStampSequence.append(chain), ats);
        }
        ArchiveTimeStampChain[] chains = this.archiveTimeStampSequence.getArchiveTimeStampChains();
        chains[chains.length - 1] = chains[chains.length - 1].append(ats);
        return new EvidenceRecord(this, new ArchiveTimeStampSequence(chains), null);
    }

    public String toString() {
        return "EvidenceRecord: Oid(" + OID + ")";
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.version);
        vector.add(this.digestAlgorithms);
        if (null != this.cryptoInfos) {
            vector.add(this.cryptoInfos);
        }
        if (null != this.encryptionInfo) {
            vector.add(this.encryptionInfo);
        }
        vector.add(this.archiveTimeStampSequence);
        return new DERSequence(vector);
    }
}

