/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.bouncycastle162.asn1.ASN1InputStream;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.DEROutputStream;
import org.bouncycastle162.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle162.asn1.util.ASN1Dump;
import org.bouncycastle162.util.Strings;
import org.bouncycastle162.util.encoders.Base64;
import org.bouncycastle162.util.test.SimpleTest;

public class EncryptedPrivateKeyInfoTest
extends SimpleTest {
    static byte[] sample1 = Base64.decode("MIIBozA9BgkqhkiG9w0BBQ0wMDAbBgkqhkiG9w0BBQwwDgQIfWBDXwLp4K4CAggAMBEGBSsOAwIHBAiaCF/AvOgQ6QSCAWDWX4BdAzCRNSQSANSuNsT5X8mWYO27mr3Y9c9LoBVXGNmYWKA77MI4967f7SmjNcgXj3xNE/jmnVz6hhsjS8E5VPT3kfyVkpdZ0lr5e9Yk2m3JWpPU7++v5zBkZmC4V/MwV/XuIs6U+vykgzMgpxQg0oZKS9zgmiZof/4dOCL0UtCDnyOSvqT7mCVIcMDIEKu8QbVlgZYBop08l60EuEU3gARUo8WsYQmODz/ldx0Z+znIT0SXVuOwc+RVItC5T/Qx+aijmmpt+9l14nmaGBrEkmuhmtdvU/4vaptewGRgmjOfD6cqK+zs0O5NrrJ3P/6ZSxXj91CQgrThGfOv72bUncXEMNtc8pks2jpHFjGMdKufnadAD7XuMgzkkaklEXZ4f5tU6heIIwr51g0GBEGF96gYPFnjnSQM75JE02Clo+DfcfXpcybPTwwFg2jd6JTTOfkdf6OdSlA/1XNK43FA");
    static byte[] sample2 = Base64.decode("MIIBpjBABgkqhkiG9w0BBQ0wMzAbBgkqhkiG9w0BBQwwDgQIeFeOWl1jywYCAggAMBQGCCqGSIb3DQMHBAjUJ5eGBhQGtQSCAWBrHrRgqO8UUMLcWzZEtpk1l3mjxiF/koCMkHsFwowgyWhEbgIkTgbSViK54LVK8PskekcGNLph+rB6bGZ7pPbL5pbXASJ8+MkQcG3FZdlS4Ek9tTJDApj3O1UubZGFG4uvTlJJFbF1BOJ3MkY3XQ9Gl1qwv7j56e103Da7Cq9+oIDKmznza78XXQYrUsPo8mJGjUxPskEYlzwvHjKubRnYm/K6RKhi5f4zX4BQ/Dt3H812ZjRXrsjAJP0KrD/jyD/jCT7zNBVPH1izBds+RwizyQAHwfNJBFR78TH4cgzB619X47FDVOnT0LqQNVd0O3cSwnPrXE9XR3tPayE+iOB15llFSmi8z0ByOXldEpkezCn92Umk++suzIVj1qfsK+bv2phZWJPbLEIWPDRHUbYf76q5ArAru4xtxT/hoK3krEs/IN3d70qjlUJ36SEw1UaZ82PWhakQbdtu39ZraMJB");
    static byte[] sample3 = Base64.decode("MIIBrjBIBgkqhkiG9w0BBQ0wOzAeBgkqhkiG9w0BBQwwEQQIrHyQPBZqWLUCAggAAgEQMBkGCCqGSIb3DQMCMA0CAToECEhbh7YZKiPSBIIBYCT1zp6o5jpFlIkgwPop7bW1+8ACr4exqzkeb3WflQ8cWJ4cURxzVdvxUnXeW1VJdaQZtjS/QHs5GhPTG/0fwtvnaPfwrIJ3FeGaZfcg2CrYhalOFmEb4xrE4KyoEQmUN8tb/Cg94uzd16BOPw21RDnE8bnPdIGY7TyL95kbkqH23mK53pi7h+xWIgduW+atIqDyyt55f7WMZcvDvlj6VpN/V0h+qxBHL274WA4dj6GYgeyUFpi60HdGCK7By2TBy8h1ZvKGjmB9h8jZvkx1MkbRumXxyFsowTZawyYvO8Um6lbfEDP9zIEUq0IV8RqH2MRyblsPNSikyYhxX/cztdDxRKhilySbSBg5Kr8OfcwKp9bpinN96nmG4xr3Tch1bnVvqJzOQ5+Vva2WwVvH2JkWvYm5WaANg4Q6bRxu9vz7DuhbJjQdZbxFezIAgrJdSe92B00jO/0Kny1WjiVO6DA=");

    public String getName() {
        return "EncryptedPrivateKeyInfoTest";
    }

    private void test(int id, byte[] sample) {
        ByteArrayInputStream bIn = new ByteArrayInputStream(sample);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        EncryptedPrivateKeyInfo info = null;
        try {
            info = EncryptedPrivateKeyInfo.getInstance(aIn.readObject());
        }
        catch (Exception e) {
            this.fail("test " + id + " failed construction - exception " + e.toString(), e);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        try {
            dOut.writeObject(info);
        }
        catch (Exception e) {
            this.fail("test " + id + " failed writing - exception " + e.toString(), e);
        }
        byte[] bytes = bOut.toByteArray();
        if (bytes.length != sample.length) {
            try {
                bIn = new ByteArrayInputStream(bytes);
                aIn = new ASN1InputStream(bIn);
                ASN1Primitive obj = aIn.readObject();
                this.fail("test " + id + " length mismatch - expected " + sample.length + Strings.lineSeparator() + ASN1Dump.dumpAsString(info) + " got " + bytes.length + Strings.lineSeparator() + ASN1Dump.dumpAsString(obj));
            }
            catch (Exception e) {
                this.fail("test " + id + " length mismatch - exception " + e.toString());
            }
        }
        for (int i = 0; i != bytes.length; ++i) {
            if (bytes[i] == sample[i]) continue;
            this.fail("test " + id + " data mismatch");
        }
    }

    public void performTest() {
        this.test(0, sample1);
        this.test(1, sample2);
        this.test(2, sample3);
    }

    public static void main(String[] args) {
        EncryptedPrivateKeyInfoTest.runTest(new EncryptedPrivateKeyInfoTest());
    }
}

