/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.cmc;

import org.bouncycastle162.asn1.ASN1Object;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.asn1.ASN1TaggedObject;
import org.bouncycastle162.asn1.DERSequence;
import org.bouncycastle162.asn1.cmc.Utils;
import org.bouncycastle162.asn1.x509.Extension;

public class ExtensionReq
extends ASN1Object {
    private final Extension[] extensions;

    public static ExtensionReq getInstance(Object obj) {
        if (obj instanceof ExtensionReq) {
            return (ExtensionReq)obj;
        }
        if (obj != null) {
            return new ExtensionReq(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static ExtensionReq getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ExtensionReq.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public ExtensionReq(Extension Extension2) {
        this.extensions = new Extension[]{Extension2};
    }

    public ExtensionReq(Extension[] extensions) {
        this.extensions = Utils.clone(extensions);
    }

    private ExtensionReq(ASN1Sequence seq) {
        this.extensions = new Extension[seq.size()];
        for (int i = 0; i != seq.size(); ++i) {
            this.extensions[i] = Extension.getInstance(seq.getObjectAt(i));
        }
    }

    public Extension[] getExtensions() {
        return Utils.clone(this.extensions);
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.extensions);
    }
}

