/*
 * Decompiled with CFR 0.152.
 */
package com.hnxc.soft.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class XmlUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseSignValue(String strxml, int type) throws Exception {
        if (null == strxml || "".equals(strxml)) {
            return null;
        }
        String result = "";
        try (InputStream in = null;){
            SAXBuilder saxBuilder = new SAXBuilder();
            in = new ByteArrayInputStream(strxml.getBytes("UTF-8"));
            Document document = saxBuilder.build(in);
            Element root = document.getRootElement();
            result = root.getChild("EInvoiceSignature").getChildren().get(type).getChildText("SignatureValue");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> parseEinvoiceInfo(String strxml) throws Exception {
        if (null == strxml || "".equals(strxml)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try (InputStream in = null;){
            SAXBuilder saxBuilder = new SAXBuilder();
            in = new ByteArrayInputStream(strxml.getBytes("UTF-8"));
            Document document = saxBuilder.build(in);
            Element root = document.getRootElement();
            Element mainElement = root.getChild("EInvoiceData").getChild("Main");
            map.put("ivcCode", mainElement.getChildTextTrim("EInvoiceCode"));
            map.put("ivcNo", mainElement.getChildTextTrim("EInvoiceNumber"));
            map.put("ckNo", mainElement.getChildTextTrim("RandomNumber"));
            map.put("payer", mainElement.getChild("PayerParty").getChildTextTrim("PayerPartyName"));
            map.put("mdate", mainElement.getChildTextTrim("IssueDate"));
            map.put("amount", mainElement.getChildTextTrim("TotalAmount"));
            ArrayList<String> itemCodes = new ArrayList<String>();
            List<Element> detailsElement = root.getChild("EInvoiceData").getChild("Details").getChildren();
            for (Element item : detailsElement) {
                itemCodes.add(item.getChildText("ItemCode"));
            }
            map.put("items", itemCodes);
        }
        return map;
    }

    public static void main(String[] args) {
        String aaa = "<?xml version='1.0' encoding='UTF-8'?><EInvoice>    <Header>        <EInvoiceTag>CZ-EI-41</EInvoiceTag>        <EInvoiceID>5888643830-32101014</EInvoiceID>        <Version>1.0.1</Version>    </Header>    <EInvoiceData>        <Main>            <EInvoiceName>\u6cb3\u5357\u7701\u653f\u5e9c\u975e\u7a0e\u6536\u5165\u8d22\u653f\u7968\u636e\uff08\u7535\u5b50\uff09</EInvoiceName>            <EInvoiceCode>41010123</EInvoiceCode>            <EInvoiceNumber>0383468885</EInvoiceNumber>            <RandomNumber>724976</RandomNumber>            <EInvoiceSpecimenCode>410101</EInvoiceSpecimenCode>            <SupervisorAreaCode>410000</SupervisorAreaCode>            <TotalAmount>200.00</TotalAmount>            <IssueDate>2023-11-08</IssueDate>            <IssueTime>11:04:19</IssueTime>            <InvoicingParty>                <InvoicingPartyCode>0000000419016187</InvoicingPartyCode>                <InvoicingPartyName>\u8bb8\u660c\u5e02\u516c\u5b89\u5c40</InvoicingPartyName>                <RecName>\u8bb8\u660c\u5e02\u516c\u5b89\u5c40</RecName>                <RecAcct></RecAcct>                <RecOpBk></RecOpBk>            </InvoicingParty>            <PayerParty>                <PayerPartyType>1</PayerPartyType>                <PayerPartyCode></PayerPartyCode>                <PayerPartyName>\u79e6\u5360\u6c38</PayerPartyName>                <PayerAcct></PayerAcct>                <PayerOpBk></PayerOpBk>            </PayerParty>            <PayMode>200</PayMode>            <BizCode></BizCode>            <CurrencyType></CurrencyType>            <Remark></Remark>            <HandlingPerson>\u5b59\u6167\u6770</HandlingPerson>            <Checker>\u5f20\u7d20\u51e4</Checker>            <SupervisorRemark></SupervisorRemark>            <MainExt/>            <InvoicingPartySeal>                <SealId></SealId>                <SealName></SealName>                <SealHash></SealHash>            </InvoicingPartySeal>            <SupervisorPartySeal>                <SealId></SealId>                <SealName></SealName>                <SealHash></SealHash>            </SupervisorPartySeal>        </Main>        <Details>            <Item>                <ItemCode>800001</ItemCode>                <ItemName>\u516c\u5b89\u7f5a\u6ca1\u6536\u5165</ItemName>                <ItemAmount>200.00</ItemAmount>                <ItemUnit>\u5143</ItemUnit>                <ItemQuantity>1</ItemQuantity>                <ItemStd>200.0000</ItemStd>                <ItemRemark></ItemRemark>                <ItemExt/>            </Item>        </Details>    </EInvoiceData>\t<EInvoiceSignature>        <Signature>            <SignedInfo>                <Reference URI=\"hash(/EInvoice/Header|/EInvoice/EInvoiceData)|/EInvoice/EInvoiceSignature/Signature[@id='InvoicingParty']\"/>                <SignatureAlgorithm>SHA256withRSAEncryption</SignatureAlgorithm>                <SignatureFormat>DETACH</SignatureFormat>            </SignedInfo>            <SignatureTime>2023-11-08 11:04:11</SignatureTime>            <SignatureValue>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</SignatureValue>            <KeyInfo>                <SerialNumber>70BAF2EFE2C4C4473F2CB1B26B4BE0DA</SerialNumber>                <X509IssuerName>CN=11410000005184603J,OU=\u6cb3\u5357\u7701\u975e\u7a0e\u6536\u5165\u5f81\u6536\u7ba1\u7406\u7cfb\u7edf-1,O=\u6cb3\u5357\u7701\u8d22\u653f\u5385,L=\u90d1\u5dde\u5e02,ST=\u6cb3\u5357\u7701,C=CN</X509IssuerName>            </KeyInfo>        </Signature>        <Signature>            <SignedInfo>                <Reference URI=\"hash(/EInvoice/Header|/EInvoice/EInvoiceData)|/EInvoice/EInvoiceSignature/Signature[@id='InvoicingParty']\"/>                <SignatureAlgorithm>SHA256withRSAEncryption</SignatureAlgorithm>                <SignatureFormat>DETACH</SignatureFormat>            </SignedInfo>            <SignatureTime>2023-11-08 11:04:11</SignatureTime>            <SignatureValue>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</SignatureValue>            <KeyInfo>                <SerialNumber>01ACA549</SerialNumber>                <X509IssuerName>CN=411002198906064542,OU=\u5b59\u6167\u6770,O=\u6cb3\u5357\u7701\u8d22\u653f\u975e\u7a0e\u7535\u5b50\u7968\u636e\u7cfb\u7edf,L=\u8bb8\u660c\u5e02,S=\u6cb3\u5357\u7701,C=CN</X509IssuerName>            </KeyInfo>        </Signature>    </EInvoiceSignature></EInvoice>";
        try {
            String dwValue = XmlUtil.parseSignValue(aaa, 1);
            System.out.println("\u7b7e\u540d\u503c\uff1a" + dwValue);
            Map<String, Object> map = XmlUtil.parseEinvoiceInfo(aaa);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                System.out.println(entry.getKey() + ":" + entry.getValue());
            }
        }
        catch (Exception e) {
            System.out.println("\u89e3\u6790\u5931\u8d25...");
            e.printStackTrace();
        }
    }
}

