/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public final class FileStore
extends StoreBase {
    private static final Log log = LogFactory.getLog(FileStore.class);
    private static final StringManager sm = StringManager.getManager(FileStore.class);
    private static final String FILE_EXT = ".session";
    private String directory = ".";
    private File directoryFile = null;
    private static final String info = "FileStore/1.0";
    private static final String storeName = "fileStore";
    private static final String threadName = "FileStore";

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String path) {
        String oldDirectory = this.directory;
        this.directory = path;
        this.directoryFile = null;
        this.support.firePropertyChange("directory", oldDirectory, this.directory);
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getThreadName() {
        return threadName;
    }

    @Override
    public String getStoreName() {
        return storeName;
    }

    @Override
    public int getSize() throws IOException {
        File dir = this.directory();
        if (dir == null) {
            return 0;
        }
        String[] files = dir.list();
        int keycount = 0;
        if (files != null) {
            for (String file : files) {
                if (!file.endsWith(FILE_EXT)) continue;
                ++keycount;
            }
        }
        return keycount;
    }

    @Override
    public void clear() throws IOException {
        String[] keys;
        for (String key : keys = this.keys()) {
            this.remove(key);
        }
    }

    @Override
    public String[] keys() throws IOException {
        File dir = this.directory();
        if (dir == null) {
            return new String[0];
        }
        String[] files = dir.list();
        if (files == null || files.length < 1) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int n = FILE_EXT.length();
        for (String file : files) {
            if (!file.endsWith(FILE_EXT)) continue;
            list.add(file.substring(0, file.length() - n));
        }
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session load(String id) throws ClassNotFoundException, IOException {
        File file = this.file(id);
        if (file == null || !file.exists()) {
            return null;
        }
        Context context = (Context)this.getManager().getContainer();
        Log containerLog = context.getLogger();
        if (containerLog.isDebugEnabled()) {
            containerLog.debug((Object)sm.getString(this.getStoreName() + ".loading", id, file.getAbsolutePath()));
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        ClassLoader oldThreadContextCL = Thread.currentThread().getContextClassLoader();
        try {
            fis = new FileInputStream(file.getAbsolutePath());
            loader = context.getLoader();
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            ois = this.getObjectInputStream(fis);
            StandardSession session = (StandardSession)this.manager.createEmptySession();
            session.readObjectData(ois);
            session.setManager(this.manager);
            StandardSession standardSession = session;
            return standardSession;
        }
        catch (FileNotFoundException e) {
            if (containerLog.isDebugEnabled()) {
                containerLog.debug((Object)"No persisted data file found");
            }
            Session session = null;
            return session;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException f) {}
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException f) {}
            }
            Thread.currentThread().setContextClassLoader(oldThreadContextCL);
        }
    }

    @Override
    public void remove(String id) throws IOException {
        File file = this.file(id);
        if (file == null) {
            return;
        }
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)sm.getString(this.getStoreName() + ".removing", id, file.getAbsolutePath()));
        }
        if (file.exists() && !file.delete()) {
            throw new IOException(sm.getString("fileStore.deleteSessionFailed", file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Session session) throws IOException {
        File file = this.file(session.getIdInternal());
        if (file == null) {
            return;
        }
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)sm.getString(this.getStoreName() + ".saving", session.getIdInternal(), file.getAbsolutePath()));
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file.getAbsolutePath());
            oos = new ObjectOutputStream(new BufferedOutputStream(fos));
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
            throw e;
        }
        try {
            ((StandardSession)session).writeObjectData(oos);
        }
        finally {
            oos.close();
        }
    }

    private File directory() throws IOException {
        if (this.directory == null) {
            return null;
        }
        if (this.directoryFile != null) {
            return this.directoryFile;
        }
        File file = new File(this.directory);
        if (!file.isAbsolute()) {
            Context context = (Context)this.manager.getContainer();
            ServletContext servletContext = context.getServletContext();
            File work = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            file = new File(work, this.directory);
        }
        if (!file.exists() || !file.isDirectory()) {
            if (!file.delete() && file.exists()) {
                throw new IOException(sm.getString("fileStore.deleteFailed", file));
            }
            if (!file.mkdirs() && !file.isDirectory()) {
                throw new IOException(sm.getString("fileStore.createFailed", file));
            }
        }
        this.directoryFile = file;
        return file;
    }

    private File file(String id) throws IOException {
        File storageDir = this.directory();
        if (storageDir == null) {
            return null;
        }
        String filename = id + FILE_EXT;
        File file = new File(storageDir, filename);
        if (!file.getCanonicalPath().startsWith(storageDir.getCanonicalPath())) {
            log.warn((Object)sm.getString("fileStore.invalid", file.getPath(), id));
            return null;
        }
        return file;
    }
}

