/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.mime.smime;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle162.mime.BasicMimeParser;
import org.bouncycastle162.mime.Headers;
import org.bouncycastle162.mime.MimeParser;
import org.bouncycastle162.mime.MimeParserProvider;
import org.bouncycastle162.mime.smime.SMimeParserContext;
import org.bouncycastle162.operator.DigestCalculatorProvider;

public class SMimeParserProvider
implements MimeParserProvider {
    private final String defaultContentTransferEncoding;
    private final DigestCalculatorProvider digestCalculatorProvider;

    public SMimeParserProvider(String defaultContentTransferEncoding, DigestCalculatorProvider digestCalculatorProvider) {
        this.defaultContentTransferEncoding = defaultContentTransferEncoding;
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    public MimeParser createParser(InputStream source) throws IOException {
        return new BasicMimeParser(new SMimeParserContext(this.defaultContentTransferEncoding, this.digestCalculatorProvider), source);
    }

    public MimeParser createParser(Headers headers, InputStream source) throws IOException {
        return new BasicMimeParser(new SMimeParserContext(this.defaultContentTransferEncoding, this.digestCalculatorProvider), headers, source);
    }
}

