/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.signers;

import java.io.ByteArrayOutputStream;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.Signer;
import org.bouncycastle162.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle162.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle162.math.ec.rfc8032.Ed448;
import org.bouncycastle162.util.Arrays;

public class Ed448Signer
implements Signer {
    private final Buffer buffer = new Buffer();
    private final byte[] context;
    private boolean forSigning;
    private Ed448PrivateKeyParameters privateKey;
    private Ed448PublicKeyParameters publicKey;

    public Ed448Signer(byte[] context) {
        this.context = Arrays.clone(context);
    }

    public void init(boolean forSigning, CipherParameters parameters) {
        this.forSigning = forSigning;
        if (forSigning) {
            this.privateKey = (Ed448PrivateKeyParameters)parameters;
            this.publicKey = this.privateKey.generatePublicKey();
        } else {
            this.privateKey = null;
            this.publicKey = (Ed448PublicKeyParameters)parameters;
        }
        this.reset();
    }

    public void update(byte b) {
        this.buffer.write(b);
    }

    public void update(byte[] buf, int off, int len) {
        this.buffer.write(buf, off, len);
    }

    public byte[] generateSignature() {
        if (!this.forSigning || null == this.privateKey) {
            throw new IllegalStateException("Ed448Signer not initialised for signature generation.");
        }
        return this.buffer.generateSignature(this.privateKey, this.publicKey, this.context);
    }

    public boolean verifySignature(byte[] signature) {
        if (this.forSigning || null == this.publicKey) {
            throw new IllegalStateException("Ed448Signer not initialised for verification");
        }
        return this.buffer.verifySignature(this.publicKey, this.context, signature);
    }

    public void reset() {
        this.buffer.reset();
    }

    private static class Buffer
    extends ByteArrayOutputStream {
        private Buffer() {
        }

        synchronized byte[] generateSignature(Ed448PrivateKeyParameters privateKey, Ed448PublicKeyParameters publicKey, byte[] ctx) {
            byte[] signature = new byte[114];
            privateKey.sign(0, publicKey, ctx, this.buf, 0, this.count, signature, 0);
            this.reset();
            return signature;
        }

        synchronized boolean verifySignature(Ed448PublicKeyParameters publicKey, byte[] ctx, byte[] signature) {
            if (114 != signature.length) {
                return false;
            }
            byte[] pk = publicKey.getEncoded();
            boolean result = Ed448.verify(signature, 0, pk, 0, ctx, this.buf, 0, this.count);
            this.reset();
            return result;
        }

        public synchronized void reset() {
            Arrays.fill(this.buf, 0, this.count, (byte)0);
            this.count = 0;
        }
    }
}

