/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.agreement;

import java.math.BigInteger;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.agreement.DHBasicAgreement;
import org.bouncycastle162.crypto.params.DHUPrivateParameters;
import org.bouncycastle162.crypto.params.DHUPublicParameters;
import org.bouncycastle162.util.Arrays;
import org.bouncycastle162.util.BigIntegers;

public class DHUnifiedAgreement {
    private DHUPrivateParameters privParams;

    public void init(CipherParameters key) {
        this.privParams = (DHUPrivateParameters)key;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getP().bitLength() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters pubKey) {
        DHUPublicParameters pubParams = (DHUPublicParameters)pubKey;
        DHBasicAgreement sAgree = new DHBasicAgreement();
        DHBasicAgreement eAgree = new DHBasicAgreement();
        sAgree.init(this.privParams.getStaticPrivateKey());
        BigInteger sComp = sAgree.calculateAgreement(pubParams.getStaticPublicKey());
        eAgree.init(this.privParams.getEphemeralPrivateKey());
        BigInteger eComp = eAgree.calculateAgreement(pubParams.getEphemeralPublicKey());
        return Arrays.concatenate(BigIntegers.asUnsignedByteArray(this.getFieldSize(), eComp), BigIntegers.asUnsignedByteArray(this.getFieldSize(), sComp));
    }
}

