/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cert.crmf;

import java.io.IOException;
import org.bouncycastle162.asn1.cms.EnvelopedData;
import org.bouncycastle162.asn1.crmf.CRMFObjectIdentifiers;
import org.bouncycastle162.asn1.crmf.EncKeyWithID;
import org.bouncycastle162.asn1.crmf.EncryptedKey;
import org.bouncycastle162.asn1.crmf.PKIArchiveOptions;
import org.bouncycastle162.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle162.asn1.x509.GeneralName;
import org.bouncycastle162.cert.crmf.PKIArchiveControl;
import org.bouncycastle162.cms.CMSEnvelopedData;
import org.bouncycastle162.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle162.cms.CMSException;
import org.bouncycastle162.cms.CMSProcessableByteArray;
import org.bouncycastle162.cms.RecipientInfoGenerator;
import org.bouncycastle162.operator.OutputEncryptor;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientGen) {
        this.envGen.addRecipientInfoGenerator(recipientGen);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor contentEncryptor) throws CMSException {
        CMSEnvelopedData envContent = this.envGen.generate(this.keyContent, contentEncryptor);
        EnvelopedData envD = EnvelopedData.getInstance(envContent.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envD)));
    }
}

