/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import org.bouncycastle162.asn1.ASN1Integer;
import org.bouncycastle162.asn1.DERSequence;
import org.bouncycastle162.asn1.DERSet;
import org.bouncycastle162.asn1.cmc.BodyPartID;
import org.bouncycastle162.asn1.cmc.CertificationRequest;
import org.bouncycastle162.asn1.cmc.OtherMsg;
import org.bouncycastle162.asn1.cmc.PKIData;
import org.bouncycastle162.asn1.cmc.TaggedAttribute;
import org.bouncycastle162.asn1.cmc.TaggedCertificationRequest;
import org.bouncycastle162.asn1.cmc.TaggedContentInfo;
import org.bouncycastle162.asn1.cmc.TaggedRequest;
import org.bouncycastle162.asn1.cms.ContentInfo;
import org.bouncycastle162.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle162.util.Arrays;
import org.bouncycastle162.util.encoders.Base64;
import org.bouncycastle162.util.test.SimpleTest;

public class PKIDataTest
extends SimpleTest {
    public static void main(String[] args) {
        PKIDataTest.runTest(new PKIDataTest());
    }

    public String getName() {
        return "PKIDataTest";
    }

    public void performTest() throws Exception {
        byte[] req1 = Base64.decode("MIHoMIGTAgEAMC4xDjAMBgNVBAMTBVRlc3QyMQ8wDQYDVQQKEwZBbmFUb20xCzAJBgNVBAYTAlNFMFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBALlEt31Tzt2MlcOljvacJgzQVhmlMoqAOgqJ9Pgd3GuxZ7/WcIlgW4QCB7WZT21O1YoghwBhPDMcNGrHei9kHQkCAwEAAaAAMA0GCSqGSIb3DQEBBQUAA0EANDEI4ecNtJ3uHwGGlitNFq9WxcoZ0djbQJ5hABMotav6gtqlrwKXY2evaIrsNwkJtNdwwH18aQDUKCjOuBL38Q==");
        PKIData pkiData = new PKIData(new TaggedAttribute[]{new TaggedAttribute(new BodyPartID(10L), PKCSObjectIdentifiers.id_aa, new DERSet())}, new TaggedRequest[]{new TaggedRequest(new TaggedCertificationRequest(new BodyPartID(10L), CertificationRequest.getInstance(req1)))}, new TaggedContentInfo[]{new TaggedContentInfo(new BodyPartID(10L), new ContentInfo(PKCSObjectIdentifiers.id_aa_ets_commitmentType, new ASN1Integer(10L)))}, new OtherMsg[]{new OtherMsg(new BodyPartID(10L), PKCSObjectIdentifiers.pkcs_9, new ASN1Integer(10L))});
        byte[] b = pkiData.getEncoded();
        PKIData pkiDataResult = PKIData.getInstance(b);
        this.isTrue("controlSequence", Arrays.areEqual(pkiData.getControlSequence(), pkiDataResult.getControlSequence()));
        this.isTrue("reqSequence", Arrays.areEqual(pkiData.getReqSequence(), pkiDataResult.getReqSequence()));
        this.isTrue("cmsSequence", Arrays.areEqual(pkiData.getCmsSequence(), pkiDataResult.getCmsSequence()));
        this.isTrue("otherMsgSequence", Arrays.areEqual(pkiData.getOtherMsgSequence(), pkiDataResult.getOtherMsgSequence()));
        try {
            PKIData.getInstance(new DERSequence());
            this.fail("Sequence must be 4.");
        }
        catch (Throwable t) {
            this.isEquals("Exception type", t.getClass(), IllegalArgumentException.class);
        }
    }
}

