/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.service.explain.verify.strategy.impl;

import api.VoucherFileInfo;
import api.VoucherFileUtil;
import com.alibaba.fastjson.JSONObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.SimpleBookmark;
import com.ygsoft.abc.eepsp.service.explain.common.type.ElecVoucherBOEnum;
import com.ygsoft.abc.eepsp.service.explain.verify.domain.vo.VerifyRecordVO;
import com.ygsoft.abc.eepsp.service.explain.verify.domain.vo.XbrlFileVO;
import com.ygsoft.abc.eepsp.service.explain.verify.impl.transfer.VerifyRecordTransfer;
import com.ygsoft.abc.eepsp.service.explain.verify.strategy.IEleVoucherParseStrategy;
import com.ygsoft.abc.eepsp.service.explain.verify.util.EepspCommonUtil;
import com.ygsoft.abc.mapp.ygca.ext.BizSignatureService2;
import com.ygsoft.abc.mapp.ygca.gwcw.common.config.VerifyConfig;
import com.ygsoft.abc.mapp.ygca.gwcw.common.types.YesnoEnum;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.VerifyResultVO;
import com.ygsoft.abc.mapp.ygca.gwcw.factory.BizSignatureServiceFactory;
import com.ygsoft.abc.mapp.ygca.gwcw.service.IBizSignatureService;
import com.ygsoft.abc.service.annotation.TLog;
import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.abc.service.exception.AbcIllegalArgumentException;
import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class EleVoucherParsePdf
implements IEleVoucherParseStrategy {
    private static final IEcpLog LOG = EcpLogFactory.getLog(EleVoucherParsePdf.class);

    @Override
    @TLog(text="\u9a8c\u7b7ePDF")
    public VerifyRecordVO parseSign(MultipartFile file) {
        VerifyRecordVO recordVO = new VerifyRecordVO();
        VerifyResultVO verifyResultVO = null;
        VerifyConfig verifyConfig = this.getVerifyConfig();
        IBizSignatureService service = BizSignatureServiceFactory.getInstance((VerifyConfig)verifyConfig);
        if (verifyConfig.getVerifyType().equals("sdk")) {
            service = new BizSignatureService2();
        }
        try {
            byte[] bytes = file.getBytes();
            verifyResultVO = service.verify(bytes, "pdf");
            recordVO = VerifyRecordTransfer.getInstance().verifyResultToVerifyRecordVO(verifyResultVO);
            recordVO.setFileName(file.getOriginalFilename());
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"\u9a8c\u7b7ePDF\u5931\u8d25", (Throwable)e);
            }
            recordVO.setSuccessed(YesnoEnum.NO);
        }
        recordVO.setVerifyTime(new Date());
        return recordVO;
    }

    @Override
    @TLog(text="\u89e3\u6790PDF")
    public JSONObject parseVoucher(MultipartFile file, String configId) {
        PreconditionUtil.checkNotNull((Object)file, (String)"PDF\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        JSONObject xbrl2Json = null;
        try {
            File tempFile = File.createTempFile("test-pdf-", file.getOriginalFilename(), null);
            String canonicalPath = tempFile.getCanonicalPath();
            BlockIOUtil.write((byte[])file.getBytes(), (String)canonicalPath);
            String xbrlFilePath = "";
            if (StringUtil.isNotEmptyString((String)configId)) {
                VoucherFileInfo extractXBRLFromPDF = VoucherFileUtil.extractXBRLFromPDF((String)canonicalPath);
                xbrlFilePath = extractXBRLFromPDF.getXbrlFilePath();
            } else {
                VoucherFileUtil.extractAttachFromPDF((String)canonicalPath, null);
                String originalFilename = file.getOriginalFilename();
                String xmlName = originalFilename.replace(".pdf", ".xml");
                xbrlFilePath = System.getProperty("java.io.tmpdir") + File.separator + xmlName;
            }
            FileInputStream in = new FileInputStream(xbrlFilePath);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while ((n = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
            byte[] data = out.toByteArray();
            tempFile.deleteOnExit();
            ((InputStream)in).close();
            out.close();
            if (null == data) {
                throw CheckFailedException.newInstance((String)"\u83b7\u53d6xbrl\u6587\u4ef6\u5931\u8d25\u3002");
            }
            if (StringUtil.isNotEmptyString((String)configId)) {
                String xbrl = new String(data, "UTF-8");
                PreconditionUtil.checkNotTrimEmpty((String)xbrl, (String)"xbrl\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                PreconditionUtil.checkNotTrimEmpty((String)configId, (String)"configId\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                xbrl2Json = VoucherFileUtil.xbrl2Json((String)xbrl, (String)configId);
            } else {
                xbrl2Json = VoucherFileUtil.xml2Json((String)new String(data, "UTF-8"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"\u8c03\u7528\u9a8c\u7b7e\u89e3\u6790PDF\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
        return xbrl2Json;
    }

    @Override
    @TLog(text="\u89e3\u6790PDF\u4e3axbrl")
    public XbrlFileVO parse2XBRL(MultipartFile file, int voucherType) {
        PreconditionUtil.checkNotNull((Object)file, (String)"PDF\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        XbrlFileVO xbrlVO = new XbrlFileVO();
        VoucherFileInfo extractXBRLFromPDF = null;
        String tempXmlFolderPath = EepspCommonUtil.spliceStr(BlockIOUtil.getTempPath(), File.separator, "parse2xbrl");
        String orignFilePath = EepspCommonUtil.spliceStr(tempXmlFolderPath, File.separator, file.getOriginalFilename());
        try {
            File folder = new File(tempXmlFolderPath);
            if (!folder.exists()) {
                try {
                    FileUtils.forceMkdir((File)folder);
                }
                catch (IOException e) {
                    throw new AbcIOException("ABC.0015", (Throwable)e);
                }
            }
            BlockIOUtil.write((byte[])file.getBytes(), (String)orignFilePath);
            extractXBRLFromPDF = VoucherFileUtil.extractXBRLFromPDF((String)orignFilePath);
        }
        catch (Exception e) {
            LOG.error((Object)"\u8c03\u7528\u9a8c\u7b7e\u89e3\u6790PDF\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
        if (null == extractXBRLFromPDF) {
            throw CheckFailedException.newInstance((String)("\u4e0d\u652f\u6301\u7684\u51ed\u8bc1\u7c7b\u578b\u3002\u6587\u4ef6\u540d\uff1a" + file.getOriginalFilename()));
        }
        String voucherTypeStr = extractXBRLFromPDF.getVoucherType();
        if (!StringUtil.isNotEmpty((String)voucherTypeStr)) {
            voucherTypeStr = ElecVoucherBOEnum.BKRS.getConfigId();
        }
        if (!voucherTypeStr.equals(ElecVoucherBOEnum.values()[voucherType].getConfigId())) {
            throw new AbcIllegalArgumentException("ABC.0030", "\u4e0a\u4f20\u6587\u4ef6\u4e0e\u6240\u9009\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d\u3002");
        }
        String xbrlFilePath = extractXBRLFromPDF.getXbrlFilePath();
        File xml = new File(xbrlFilePath);
        String xmlPath = EepspCommonUtil.spliceStr(tempXmlFolderPath, File.separator, xml.getName());
        xbrlVO.setXbrlTempPath(xmlPath);
        InputStream in = null;
        FileOutputStream outFile = null;
        ByteArrayOutputStream out = null;
        try {
            outFile = new FileOutputStream(xmlPath);
            in = new FileInputStream(xbrlFilePath);
            out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
                outFile.write(buffer, 0, n);
                outFile.flush();
            }
            byte[] data = out.toByteArray();
            BlockIOUtil.deleteFile((String)orignFilePath);
            BlockIOUtil.deleteFile((String)xbrlFilePath);
            if (null == data) {
                throw CheckFailedException.newInstance((String)"\u83b7\u53d6xbrl\u6587\u4ef6\u5931\u8d25\u3002");
            }
            String xbrl = new String(data, "UTF-8");
            xbrlVO.setXbrlJsonString(xbrl);
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0015", (Throwable)e);
        }
        finally {
            try {
                in.close();
                out.close();
                outFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        PreconditionUtil.checkNotTrimEmpty((String)xbrlVO.getXbrlJsonString(), (String)"xbrl\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        return xbrlVO;
    }

    @Override
    public Object getAllElec(MultipartFile file) {
        PreconditionUtil.checkNotNull((Object)file, (String)"PDF\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Object extractXBRLFromPDF = null;
        String tempXmlFolderPath = EepspCommonUtil.spliceStr(BlockIOUtil.getTempPath(), File.separator, "parse2xbrl");
        String orignFilePath = EepspCommonUtil.spliceStr(tempXmlFolderPath, File.separator, file.getOriginalFilename());
        try {
            File folder = new File(tempXmlFolderPath);
            if (!folder.exists()) {
                try {
                    FileUtils.forceMkdir((File)folder);
                }
                catch (IOException e) {
                    throw new AbcIOException("ABC.0015", (Throwable)e);
                }
            }
            BlockIOUtil.write((byte[])file.getBytes(), (String)orignFilePath);
            PdfReader pdfReader = new PdfReader(orignFilePath);
            List list = SimpleBookmark.getBookmark((PdfReader)pdfReader);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                EleVoucherParsePdf.showBookmark((HashMap)i.next());
            }
            i = list.iterator();
            while (i.hasNext()) {
                EleVoucherParsePdf.getPageNumbers((HashMap)i.next());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"\u8c03\u7528\u9a8c\u7b7e\u89e3\u6790PDF\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
        if (null == extractXBRLFromPDF) {
            throw CheckFailedException.newInstance((String)("\u4e0d\u652f\u6301\u7684\u51ed\u8bc1\u7c7b\u578b\u3002\u6587\u4ef6\u540d\uff1a" + file.getOriginalFilename()));
        }
        return "";
    }

    @Override
    public Object getNotGwSpecialVat(MultipartFile file) {
        return null;
    }

    private static void showBookmark(HashMap<String, Object> bookmark) {
        System.out.println(bookmark.get("Title"));
        ArrayList kids = (ArrayList)bookmark.get("Kids");
        if (kids == null) {
            return;
        }
        Iterator i = kids.iterator();
        while (i.hasNext()) {
            EleVoucherParsePdf.showBookmark((HashMap)i.next());
        }
    }

    public static void getPageNumbers(HashMap<String, Object> bookmark) {
        if (bookmark == null) {
            return;
        }
        if ("GoTo".equals(bookmark.get("Action"))) {
            ArrayList kids;
            String page = (String)bookmark.get("Page");
            if (page != null) {
                int pageNum;
                int idx = (page = page.trim()).indexOf(32);
                if (idx < 0) {
                    pageNum = Integer.parseInt(page);
                    System.out.println("pageNum :" + pageNum);
                } else {
                    pageNum = Integer.parseInt(page.substring(0, idx));
                    System.out.println("pageNum:" + pageNum);
                }
            }
            if ((kids = (ArrayList)bookmark.get("Kids")) == null) {
                return;
            }
            Iterator i = kids.iterator();
            while (i.hasNext()) {
                EleVoucherParsePdf.getPageNumbers((HashMap)i.next());
            }
        }
    }

    @Override
    public ElecVoucherBOEnum getElecVoucherBOEunm(MultipartFile file) {
        String originalFilename = file.getOriginalFilename();
        try {
            ElecVoucherBOEnum[] elecVoucherBOs;
            File tempFile = File.createTempFile("test-", originalFilename, null);
            String canonicalPath = tempFile.getCanonicalPath();
            BlockIOUtil.write((byte[])file.getBytes(), (String)canonicalPath);
            VoucherFileInfo extractXBRLFromPDF = VoucherFileUtil.extractXBRLFromPDF((String)canonicalPath);
            if (null == extractXBRLFromPDF) {
                return null;
            }
            String voucherType = extractXBRLFromPDF.getVoucherType();
            if (null == voucherType) {
                return ElecVoucherBOEnum.BKRS;
            }
            for (ElecVoucherBOEnum boEnum : elecVoucherBOs = ElecVoucherBOEnum.values()) {
                String configId = boEnum.getConfigId();
                if (!StringUtils.isNotEmpty((CharSequence)configId) || voucherType.indexOf(configId) != 0) continue;
                tempFile.deleteOnExit();
                return boEnum;
            }
            tempFile.deleteOnExit();
        }
        catch (Exception e) {
            LOG.error((Object)"\u4ecePDF\u83b7\u53d6XBRL\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
        throw CheckFailedException.newInstance((String)("\u4e0d\u652f\u6301\u7684\u51ed\u8bc1\u7c7b\u578b\u3002\u6587\u4ef6\u540d\uff1a" + originalFilename));
    }
}

